package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.project.model.GetProjectRequest;

/**
 * GetProjectRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id GetProjectRequestMarshaller 2016-09-21 16:50:30z dzungvnguyen $
 * @since 1.0
 */
public class GetProjectRequestMarshaller extends AbstractProjectRequestMarshaller<GetProjectRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(GetProjectRequest getProjectRequest) throws Exception {
    // validate module request.
    getProjectRequest = ApiPreconditions.notNull(getProjectRequest);
    validateProjectId(getProjectRequest.getProjectId());

    // create request.
    Request request = createJsonRequest(getProjectRequest, "GetProject", HttpMethod.GET);

    // create resource builder.
    request.setResourcePath(createApiBasePathWithProject(getProjectRequest.getProjectId()).toString());

    // set request parameter.
    final StringBuilder expandBuilder = new StringBuilder();
    if (getProjectRequest.isIncludeAlwaysOn()) {
      expandBuilder.append("always_on");
    }

    if (getProjectRequest.isIncludeUserProfile()) {
      if (expandBuilder.length() > 0) {
        expandBuilder.append(",");
      }

      expandBuilder.append("userprofile");
    }


    // return the request.
    return request;
  }
}
