package org.qas.qtest.api.services.project.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * MoveModuleRequest
 *
 * @author Dzung Nguyen
 * @version $Id MoveModuleRequest 2015-06-01 17:03:30z dzungvnguyen $
 * @since 1.0
 */
public final class MoveModuleRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long moduleId;
  private Long parentId;

  //~ class members ===========================================================
  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier.
   * @return the move module request instance.
   */
  public MoveModuleRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the module identifier.
   */
  public Long getModuleId() {
    return moduleId;
  }

  /**
   * Sets the module identifier.
   *
   * @param moduleId the given module identifier to set.
   */
  public void setModuleId(Long moduleId) {
    this.moduleId = moduleId;
  }

  /**
   * Sets the module identifier.
   *
   * @param moduleId the given module identifier to set.
   * @return current instance.
   */
  public MoveModuleRequest withModuleId(Long moduleId) {
    setModuleId(moduleId);
    return this;
  }

  /**
   * @return the parent identifier.
   */
  public Long getParentId() {
    return parentId;
  }

  /**
   * Sets the parent identifier.
   *
   * @param parentId the given parent identifier toset.
   */
  public void setParentId(Long parentId) {
    this.parentId = parentId;
  }

  /**
   * Sets the parent identifier.
   *
   * @param parentId the given parent identifier to set.
   * @return current instance.
   */
  public MoveModuleRequest withParentId(Long parentId) {
    setParentId(parentId);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("MoveModuleRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", moduleId=").append(moduleId);
    sb.append(", parentId=").append(parentId);
    sb.append('}');
    return sb.toString();
  }
}
