package org.qas.qtest.api.services.project.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * ListModuleRequest by default {@link #includeClosed} is set to true
 *
 * @author Dzung Nguyen
 * @version $Id ListModuleRequest 2015-01-16 15:51:30z dzungvnguyen $
 * @since 1.0
 */
public final class ListReleaseRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private boolean includeClosed = true;

  //~ class members ===========================================================

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the project identifier to set.
   */
  public ListReleaseRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return include closed flag.
   */
  public boolean isIncludeClosed() {
    return includeClosed;
  }

  /**
   * Sets the include closed flag.
   *
   * @param includeClosed the given include descendants flag to set.
   */
  public void setIncludeClosed(boolean includeClosed) {
    this.includeClosed = includeClosed;
  }

  /**
   * Sets the include closed flag.
   *
   * @param includeDescendants the given include closed flag to set.
   * @return current {@link GetModuleRequest get module request} instance.
   */
  public ListReleaseRequest withIncludeClosed(boolean includeDescendants) {
    setIncludeClosed(includeDescendants);
    return this;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder(this.getClass().getName());

    builder.append("{").append("\n")
       .append("\t").append("projectId: ").append(projectId).append(",").append("\n")
       .append("\t").append("includeClosed: ").append(includeClosed).append("\n")
       .append("}");

    return builder.toString();
  }
}
