package org.qas.qtest.api.services.project.model;

import org.qas.api.ApiServiceRequest;

/**
 * ListProjectRequest
 *
 * @author Dzung Nguyen
 * @version $Id ListProjectRequest 2014-03-27 17:39:30z dungvnguyen $
 * @since 1.0
 */
public final class ListProjectRequest extends ApiServiceRequest {
  private boolean assignOnly = false;

  /**
   * Obtains the assign only flag.
   *
   * @return the assign only flag.
   */
  public boolean isAssignOnly() {
    return assignOnly;
  }

  /**
   * Sets the assign only.
   *
   * @param assignOnly the given assign only value.
   */
  public void setAssignOnly(boolean assignOnly) {
    this.assignOnly = assignOnly;
  }

  /**
   * Sets the assign only.
   *
   * @param assignOnly the given assign only value.
   * @return the {@link ListProjectRequest list project request} instance.
   */
  public ListProjectRequest withAssignOnly(boolean assignOnly) {
    setAssignOnly(assignOnly);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("ListProjectRequest{");
    sb.append("assignOnly=").append(assignOnly);
    sb.append('}');
    return sb.toString();
  }
}
