package org.qas.qtest.api.services.project.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * GetProjectRequest
 *
 * @author Dzung Nguyen
 * @version $Id GetProjectRequest 2016-09-21 16:33:30z dzungvnguyen $
 * @since 1.0
 */
public class GetProjectRequest extends AbstractQTestApiServiceRequest {
  private boolean includeUserProfile;
  private boolean includeAlwaysOn;

  //~ class members ===========================================================
  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the project identifier to set.
   */
  public GetProjectRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return include user profile flag.
   */
  public boolean isIncludeUserProfile() {
    return includeUserProfile;
  }

  /**
   * Sets the include user profile flag.
   *
   * @param includeUserProfile the given include user profile flag to set.
   */
  public void setIncludeUserProfile(boolean includeUserProfile) {
    this.includeUserProfile = includeUserProfile;
  }

  /**
   * Sets the include user profile flag.
   *
   * @param includeUserProfile the given include user profile flag to set.
   * @return current {@link GetProjectRequest get project request} instance.
   */
  public GetProjectRequest withIncludeUserProfile(boolean includeUserProfile) {
    setIncludeUserProfile(includeUserProfile);
    return this;
  }

  /**
   * @return include always on flag.
   */
  public boolean isIncludeAlwaysOn() {
    return includeAlwaysOn;
  }

  /**
   * Sets the include always on flag.
   *
   * @param includeAlwaysOn the given include always on flag to set.
   */
  public void setIncludeAlwaysOn(boolean includeAlwaysOn) {
    this.includeAlwaysOn = includeAlwaysOn;
  }

  /**
   * Sets the include user profile flag.
   *
   * @param includeAlwaysOn the given include always on flag to set.
   * @return current {@link GetProjectRequest get project request} instance.
   */
  public GetProjectRequest withIncludeAlwaysOn(boolean includeAlwaysOn) {
    setIncludeAlwaysOn(includeAlwaysOn);
    return this;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder(this.getClass().getName());

    builder.append("{").append("\n")
        .append("\t").append("projectId: ").append(projectId).append(",").append("\n")
        .append("\t").append("includeUserProfile: ").append(includeUserProfile).append(",").append("\n")
        .append("\t").append("includeAlwaysOn: ").append(includeAlwaysOn).append("\n")
        .append("}");

    return builder.toString();
  }
}
