package org.qas.qtest.api.services.project.model;

import org.qas.api.ApiServiceRequest;
import org.qas.qtest.api.internal.model.ObjectType;

/**
 * GetFieldsRequest
 *
 * @author Dzung Nguyen
 * @version $Id GetFieldsRequest 2014-07-14 21:41:30z dungvnguyen $
 * @since 1.0
 */
public final class GetFieldsRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;
  private ObjectType objectType;
  private boolean includeInactive;

  //~ class members ===========================================================

  /**
   * @return the project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the current request instance.
   */
  public GetFieldsRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the request object type.
   */
  public ObjectType getObjectType() {
    return objectType;
  }

  /**
   * Sets the request object type.
   *
   * @param objectType the given request object type to set.
   */
  public void setObjectType(ObjectType objectType) {
    this.objectType = objectType;
  }

  /**
   * Sets the request object type.
   *
   * @param objectType the given request object type to set.
   * @return current request instance.
   */
  public GetFieldsRequest withObjectType(ObjectType objectType) {
    setObjectType(objectType);
    return this;
  }

  /**
   * @return includeInactive
   */
  public boolean isIncludeInactive() {
    return includeInactive;
  }

  /**
   * @param includeInactive includeInactive
   * @return current instance.
   */
  public GetFieldsRequest setIncludeInactive(boolean includeInactive) {
    this.includeInactive = includeInactive;
    return this;
  }

  /**
   * @param includeInactive includeInactive
   * @return current instance.
   */
  public GetFieldsRequest withIncludeInactive(boolean includeInactive) {
    this.includeInactive = includeInactive;
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("GetFieldsRequest{\n");
    sb.append("\tprojectId: ").append(projectId).append(",\n");
    sb.append("\tobjectType: ").append(objectType).append("\n");
    sb.append("\tincludeInactive: ").append(includeInactive).append("\n");
    sb.append('}');
    return sb.toString();
  }
}
