package org.qas.qtest.api.services.project.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * DeleteModuleRequest
 *
 * @author Dzung Nguyen
 * @version $Id DeleteModuleRequest 2015-06-01 17:18:30z dzungvnguyen $
 * @since 1.0
 */
public final class DeleteModuleRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long moduleId;
  private boolean force = false;

  //~ class members ===========================================================

  /**
   * @return if user want to force remove its descendant modules.
   */
  public boolean isForce() {
    return force;
  }

  /**
   * Sets force flag.
   *
   * @param force the given force flag to set.
   */
  public void setForce(boolean force) {
    this.force = force;
  }

  /**
   * Sets force flag.
   *
   * @param force the given force flag to set.
   * @return current instance.
   */
  public DeleteModuleRequest withForce(boolean force) {
    setForce(force);
    return this;
  }

  /**
   * @return the module identifier.
   */
  public Long getModuleId() {
    return moduleId;
  }

  /**
   * Sets the module identifier.
   *
   * @param moduleId the given module identifier to set.
   */
  public void setModuleId(Long moduleId) {
    this.moduleId = moduleId;
  }

  /**
   * Sets the module identifier.
   *
   * @param moduleId the given module identifier to set.
   * @return current instance.
   */
  public DeleteModuleRequest withModuleId(Long moduleId) {
    setModuleId(moduleId);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("DeleteModuleRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", moduleId=").append(moduleId);
    sb.append(", force=").append(force);
    sb.append('}');
    return sb.toString();
  }
}
