package org.qas.qtest.api.services.plan;

import org.qas.api.AuthServiceException;
import org.qas.api.handler.AsyncHandler;
import org.qas.qtest.api.services.plan.model.Build;
import org.qas.qtest.api.services.plan.model.CreateBuildRequest;
import org.qas.qtest.api.services.plan.model.CreateReleaseRequest;
import org.qas.qtest.api.services.plan.model.Release;

import java.util.concurrent.Future;

/**
 * TestPlanServiceAsync
 *
 * @author Dzung Nguyen
 * @version $Id TestPlanServiceAsync 2014-07-18 15:10:30z dungvnguyen $
 * @since 1.0
 */
public interface TestPlanServiceAsync extends TestPlanService {
  /**
   * Creates release from the {@link CreateReleaseRequest} .
   *
   * @param createReleaseRequest the given {@link CreateReleaseRequest create release request}
   * @return the {@link Release} instance.
   * @throws AuthServiceException if an error occurs during creating release.
   */
  Future<Release> createReleaseAsync(CreateReleaseRequest createReleaseRequest) throws AuthServiceException;

  /**
   * Creates release from the {@link CreateReleaseRequest} .
   *
   * @param createReleaseRequest the given {@link CreateReleaseRequest create release request}
   * @param asyncHandler callback handler for events in the life-cycle of the request.
   *                     Users could provide the implementation of the for callback
   *                     methods in this interface to process the operation result or
   *                     handle the exception.
   * @return the {@link Release} instance.
   * @throws AuthServiceException if an error occurs during creating release.
   */
  Future<Release> createReleaseAsync(CreateReleaseRequest createReleaseRequest,
                                     AsyncHandler<CreateReleaseRequest, Release> asyncHandler) throws AuthServiceException;

  /**
   * Creates build from the {@link CreateBuildRequest create build request}
   *
   * @param createBuildRequest the given {@link CreateBuildRequest create build request}
   * @return the {@link Build} instance.
   * @throws AuthServiceException if an error occurs during creating build.
   */
  Future<Build> createBuildAsync(CreateBuildRequest createBuildRequest) throws AuthServiceException;

  /**
   * Creates build from the {@link CreateBuildRequest create build request}
   *
   * @param createBuildRequest the given {@link CreateBuildRequest create build request}
   * @param asyncHandler callback handler for events in the life-cycle of the request.
   *                     Users could provide the implementation of the for callback
   *                     methods in this interface to process the operation result or
   *                     handle the exception.
   * @return the {@link Build} instance.
   * @throws AuthServiceException if an error occurs during creating build.
   */
  Future<Build> createBuildAsync(CreateBuildRequest createBuildRequest,
                                 AsyncHandler<CreateBuildRequest, Build> asyncHandler) throws AuthServiceException;
}
