package org.qas.qtest.api.services.link.transform;

import org.apache.commons.collections.CollectionUtils;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Joiner;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.api.transform.Marshaller;
import org.qas.qtest.api.services.link.model.CreateArtifactLinkRequest;
import org.qas.qtest.api.services.link.model.GetArtifactLinkRequest;

/**
 * @author trongle
 * @version $Id 4/21/2017 4:21 PM
 */
public class GetArtifactLinkMarshaller extends AbstractMarshaller<Request, GetArtifactLinkRequest> {

  @Override
  protected void validateRequest(GetArtifactLinkRequest in) throws Exception {
    if (in == null) {
      throw new IllegalArgumentException("Invalid request");
    }
    if (in.getProjectId() == null || in.getProjectId() <= 0) {
      throw new IllegalArgumentException("Invalid project id");
    }
    if (in.getType() == null) {
      throw new IllegalArgumentException("Invalid artifact type id");
    }
    if (CollectionUtils.isEmpty(in.getArtifactIds())) {
      throw new IllegalArgumentException("Invalid artifact ids");
    }
  }


  @Override
  protected String getServiceName() {
    return "ArtifactLink";
  }

  @Override
  protected String getActionName() {
    return "GetArtifactLink";
  }

  @Override
  protected String getContent(GetArtifactLinkRequest in) {
    return "";
  }

  @Override
  protected StringBuilder getResourcePath(GetArtifactLinkRequest in, StringBuilder rpBuilder) {
    rpBuilder.append("/api/v3/projects/")
      .append(in.getProjectId().longValue()).append("/")
      .append("linked-artifacts")
      .append("?type=" + in.getType().getPath())
      .append("&ids=" + Joiner.on(",").join(in.getArtifactIds()));
    return rpBuilder;
  }
}
