package org.qas.qtest.api.services.link.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.qtest.api.services.link.model.CreateArtifactLinkRequest;

/**
 * @author trongle
 * @version $Id 4/21/2017 4:21 PM
 */
public class DeleteArtifactLinkMarshaller extends CreateArtifactLinkMarshaller {

  @Override
  protected void build(Request request, CreateArtifactLinkRequest in) {
    request.setHttpMethod(HttpMethod.DELETE);
  }

  @Override
  protected String getActionName() {
    return "DeleteArtifactLink";
  }

  @Override
  protected StringBuilder getResourcePath(CreateArtifactLinkRequest in, StringBuilder rpBuilder) {
    rpBuilder.append(String.format("/api/v3/projects/%s/%s/%s/link?type=%s",
      in.getProjectId(),
      in.getDestObjectType().getPath(),
      in.getDestArtifactId(),
      in.getSourceObjectType().getPath()));
    return rpBuilder;
  }
}
