package org.qas.qtest.api.services.host.model.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.host.model.Job;

import java.util.List;

/**
 * ListJobJsonUnmarshaller
 *
 * @author Chuong Le
 * @version $Id ListJobJsonUnmarshaller 2015-03-19 11:27:30z chuongle $
 * @since 1.0
 */
public final class ListJobJsonUnmarshaller extends AbstractUnmarshaller<List<Job>, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  static ListJobJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static ListJobJsonUnmarshaller getInstance() {
    if (instance == null) instance = new ListJobJsonUnmarshaller();
    return instance;
  }

  @Override
  public List<Job> parse(String data) throws Exception {
    return JsonMapper.parseJson(data, new TypeReference<List<Job>>() {
    });
  }
}
