package org.qas.qtest.api.services.host.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.host.model.AutomationAgent;

/**
 * AutomationAgentJsonUnmarshaller
 *
 * @author Thong Nguyen
 * @version $Id AutomationAgentJsonUnmarshaller 2015-03-14 22:11:30z thongnguyen $
 * @since 1.0
 */
public class AutomationAgentJsonUnmarshaller extends AbstractUnmarshaller<AutomationAgent, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static AutomationAgentJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static AutomationAgentJsonUnmarshaller getInstance() {
    if (instance == null) instance = new AutomationAgentJsonUnmarshaller();
    return instance;
  }

  @Override
  public AutomationAgent parse(String data) throws Exception {
    return JsonMapper.parseJson(data, AutomationAgent.class);
  }
}
