package org.qas.qtest.api.services.host.model;

import java.util.Date;

import org.qas.api.ApiServiceRequest;

/**
 * RunningTaskRequest
 *
 * @author chuongle
 * @version $Id RunningTaskRequest Mar 17, 2015 6:56:23 PM chuongle $
 * @since 1.0
 */
public class ListJobRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long hostServerId;
  private Date startDate;
  private Date endDate;

  //~ class members ===========================================================
  /**
   * @return the start date
   */
  public Date getStartDate() {
    return startDate;
  }

  /**
   * Sets the start date.
   *
   * @param startDate the start date to set
   */
  public void setStartDate(Date startDate) {
    this.startDate = startDate;
  }

  /**
   * Sets the start date.
   *
   * @param startDate the given start date to set.
   * @return the list job request.
   */
  public ListJobRequest withStartDate(Date startDate) {
    setStartDate(startDate);
    return this;
  }

  /**
   * @return the end date
   */
  public Date getEndDate() {
    return endDate;
  }

  /**
   * Sets the end date.
   *
   * @param endDate the end date to set.
   */
  public void setEndDate(Date endDate) {
    this.endDate = endDate;
  }

  /**
   * Sets the end date.
   *
   * @param endDate the end date to set.
   * @return the list job request.
   */
  public ListJobRequest withEndDate(Date endDate) {
    setEndDate(endDate);
    return this;
  }

  /**
   * @return host server identifier.
   */
  public Long getHostServerId() {
    return hostServerId;
  }

  /**
   * Sets the host server identifier.
   *
   * @param hostServerId the given host server identifier to set.
   */
  public void setHostServerId(Long hostServerId) {
    this.hostServerId = hostServerId;
  }

  /**
   * Sets the host server identifier.
   *
   * @param hostServerId the given host server identifier.
   * @return the list job request instance.
   */
  public ListJobRequest withHostServerId(Long hostServerId) {
    setHostServerId(hostServerId);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("ListJobRequest{");
    sb.append("hostServerId=").append(hostServerId);
    sb.append(", startDate=").append(startDate);
    sb.append(", endDate=").append(endDate);
    sb.append('}');
    return sb.toString();
  }
}
