package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.services.execution.model.UpdateTestCycleRequest;
import org.qas.qtest.api.internal.util.ApiPreconditions;

/**
 * UpdateTestCycleRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id UpdateTestCycleRequestMarshaller 2015-05-29 07:18:30z dzungvnguyen $
 * @since 1.0
 */
public final class UpdateTestCycleRequestMarshaller
  extends AbstractTestCycleRequestMarshaller<UpdateTestCycleRequest> {
  //~ class members ===========================================================
  @Override
  public Request marshall(UpdateTestCycleRequest testCycleRequest) throws Exception {
    // validate input.
    testCycleRequest = ApiPreconditions.notNull(testCycleRequest);
    validateProjectId(testCycleRequest.getProjectId());
    ApiPreconditions.notNull(testCycleRequest.getTestCycle(), "Invalid test-cycle data passed to marshall(...)");

    // resolve test cycle identifier.
    Long testCycleId = (testCycleRequest.getTestCycleId() != null
      ? testCycleRequest.getTestCycleId()
      : testCycleRequest.getTestCycle().getId()
    );
    validateTestCycleId(testCycleId);

    // normalize the test-cycle identifier.
    testCycleRequest.getTestCycle().setId(testCycleId);

    // create update request.
    Request request = createJsonRequest(testCycleRequest, "UpdateTestCycle", HttpMethod.PUT);

    // set resource path.
    StringBuilder builder = createApiPathBuilder(testCycleRequest.getProjectId());
    builder.append('/').append(testCycleId.longValue());
    request.setResourcePath(builder.toString());

    // set resource content.
    request.setContent(new StringInputStream(JsonMapper.toJson(testCycleRequest.getTestCycle())));
    return request;
  }
}
