package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.execution.model.TestRun;

/**
 * TestRunJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id TestRunJsonUnmarshaller 2014-03-29 06:24:30z dungvnguyen $
 * @since 1.0
 */
public final class TestRunJsonUnmarshaller extends AbstractUnmarshaller<TestRun, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static TestRunJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static TestRunJsonUnmarshaller getInstance() {
    if (instance == null) instance = new TestRunJsonUnmarshaller();
    return instance;
  }

  @Override
  public TestRun parse(String data) throws Exception {
    return JsonMapper.parseJson(data, TestRun.class);
  }
}
