package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.execution.model.QueueProcessingResponseRequest;

public final class QueueProcessingResponseRequestMarshaller
    extends AbstractMarshaller<Request, QueueProcessingResponseRequest> {

  @Override
  protected void validateRequest(QueueProcessingResponseRequest in) {
    if (null == in) {
      throw new AuthClientException("Invalid argument passed to marshall(...)");
    }
    if (null == in.getId()) {
      throw new AuthClientException("Invalid id passed to marshall(...)");
    }
  }

  @Override
  protected String getServiceName() {
    return "TestExecutionService";
  }

  @Override
  protected String getActionName() {
    return "GetBatchTestLogSubmissionJobState";
  }

  @Override
  protected String getContent(QueueProcessingResponseRequest in) {
    return JsonMapper.toJson(in);
  }

  /*
   * See #https://api.qasymphony.com/#/test-log/track for more information
   */
  @Override
  protected StringBuilder getResourcePath(QueueProcessingResponseRequest in, StringBuilder rpBuilder) {
    rpBuilder.append("/api/v3/projects/queue-processing/")
        .append(in.getId());
    return rpBuilder;
  }
}
