package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.execution.model.ListExecutionStatusRequest;

/**
 * ListExecutionStatusRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id ListExecutionStatusRequestMarshaller 2014-05-06 11:05:30z dungvnguyen $
 * @since 1.0
 */
public final class ListExecutionStatusRequestMarshaller extends AbstractMarshaller<Request, ListExecutionStatusRequest> {

  @Override
  protected void validateRequest(ListExecutionStatusRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid argument passed to marshall(...)");
    }
    if (in.getProjectId() == null || in.getProjectId() < 0L) {
      throw new AuthClientException("Invalid project id passed to marshall(...)");
    }
  }

  @Override
  protected String getServiceName() {
    return "TestExecutionService";
  }

  @Override
  protected String getActionName() {
    return "ListExecutionStatus";
  }

  @Override
  protected String getContent(ListExecutionStatusRequest in) throws Exception {
    return null;
  }

  @Override
  protected StringBuilder getResourcePath(ListExecutionStatusRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/v3/projects/")
      .append(in.getProjectId())
      .append("/test-runs/execution-statuses");
  }
}
