package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * UpdateTestSuiteRequest
 *
 * @author Dzung Nguyen
 * @version $Id UpdateTestSuiteRequest 2015-05-29 17:18:30z dzungvnguyen $
 * @since 1.0
 */
public class UpdateTestSuiteRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  protected Long testSuiteId;
  protected TestSuite testSuite;

  //~ class members ===========================================================
  /**
   * Sets project id.
   *
   * @param projectId the given project identifier to set.
   * @return the current update test-suite request.
   */
  public UpdateTestSuiteRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test-suite identifier.
   */
  public Long getTestSuiteId() {
    return testSuiteId;
  }

  /**
   * Sets the test-suite identifier.
   *
   * @param testSuiteId the given test-suite identifier to set.
   */
  public void setTestSuiteId(Long testSuiteId) {
    this.testSuiteId = testSuiteId;
  }

  /**
   * Sets the test-suite identifier.
   *
   * @param testSuiteId the given test-suite identifier.
   * @return current update test-suite request.
   */
  public UpdateTestSuiteRequest withTestSuiteId(Long testSuiteId) {
    setTestSuiteId(testSuiteId);
    return this;
  }

  /**
   * @return the test suite.
   */
  public TestSuite getTestSuite() {
    return testSuite;
  }

  /**
   * Sets the test-suite.
   *
   * @param testSuite the given test-suite instance.
   */
  public void setTestSuite(TestSuite testSuite) {
    this.testSuite = testSuite;
  }

  /**
   * Sets the test-suite instance.
   *
   * @param testSuite the given test-suite instance to set.
   * @return the update test suite request instance.
   */
  public UpdateTestSuiteRequest withTestSuite(TestSuite testSuite) {
    setTestSuite(testSuite);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("UpdateTestSuiteRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", testSuite=").append(testSuite);
    sb.append(", testSuiteId=").append(testSuiteId);
    sb.append('}');
    return sb.toString();
  }
}
