package org.qas.qtest.api.services.execution.model;

import org.qas.api.ApiServiceRequest;

/**
 * TestLogRequest
 *
 * @author Dzung Nguyen
 * @version $Id TestLogRequest 2014-10-24 13:42:30z dungvnguyen $
 * @since 1.0
 */
public class SubmitTestLogRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;
  private Long testRunId;
  private TestLog testLog;
  private String externalToken;

  //~ class members ===========================================================

  /**
   * Sets the test log.
   *
   * @param testLog the given test log.
   */
  public void setTestLog(TestLog testLog) {
    this.testLog = testLog;
  }

  /**
   * @return the test log instance.
   */
  public TestLog getTestLog() {
    return this.testLog;
  }

  /**
   * Sets the test log.
   *
   * @param testLog the given test log to set.
   * @return the current {@link SubmitTestLogRequest} object.
   */
  public SubmitTestLogRequest withTestLog(TestLog testLog) {
    setTestLog(testLog);
    return this;
  }

  /**
   * @return the project id.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project id to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project id to set.
   * @return the current {@link SubmitTestLogRequest} object.
   */
  public SubmitTestLogRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test run id.
   */
  public Long getTestRunId() {
    return testRunId;
  }

  /**
   * Sets the test run id.
   *
   * @param testRunId the given test run identifier to set.
   */
  public void setTestRunId(Long testRunId) {
    this.testRunId = testRunId;
  }

  /**
   * Sets the test run id.
   *
   * @param testRunId the given test run identifier to set.
   * @return the current {@link SubmitTestLogRequest} object.
   */
  public SubmitTestLogRequest withTestRunId(Long testRunId) {
    setTestRunId(testRunId);
    return this;
  }

  /**
   * @return the external token.
   */
  public String getExternalToken() {
    return externalToken;
  }

  /**
   * Sets the external token.
   *
   * @param externalToken the given external token to set.
   */
  public void setExternalToken(String externalToken) {
    this.externalToken = externalToken;
  }

  /**
   * Sets the external token.
   *
   * @param externalToken the given external token to set.
   * @return the current submit test log request instance.
   */
  public SubmitTestLogRequest withExternalToken(String externalToken) {
    setExternalToken(externalToken);
    return this;
  }
}
