package org.qas.qtest.api.services.execution.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import org.qas.qtest.api.internal.model.QTestBaseModel;

/**
 * ExecutionStatus
 *
 * @author Dzung Nguyen
 * @version $Id ExecutionStatus 2014-03-28 06:16:30z dungvnguyen $
 * @since 1.0
 */
public class ExecutionStatus extends QTestBaseModel<ExecutionStatus> {

  @JsonProperty("id")
  private Long id;

  @JsonProperty("name")
  private String name;

  public ExecutionStatus() {
  }

  /**
   * @return the execution status identifier.
   */
  public Long getId() {
    return id;
  }

  /**
   * Sets the execution status identifier.
   *
   * @param id the given status identifier to set.
   */
  public ExecutionStatus setId(Long id) {
    this.id = id;
    return this;
  }

  /**
   * Sets the execution status identifier.
   *
   * @param id the given status identifier to set.
   * @return the current object.
   */
  public ExecutionStatus withId(Long id) {
    setId(id);
    return this;
  }

  /**
   * @return the execution status name.
   */
  public String getName() {
    return name;
  }

  /**
   * Sets the execution status name.
   *
   * @param name the given execution status name to set.
   */
  public ExecutionStatus setName(String name) {
    this.name = name;
    return this;
  }

  /**
   * Sets the execution status name.
   *
   * @param name the given execution status name to set.
   */
  public ExecutionStatus withName(String name) {
    setName(name);
    return this;
  }

  @Override
  protected ExecutionStatus clone() {
    ExecutionStatus that = new ExecutionStatus();
    that.setPropertiesFrom(this);
    return that;
  }

  @Override
  public String elementName() { return "execution-status"; }

  @Override
  public String jsonElementName() { return "status"; }
}
