package org.qas.qtest.api.services.execution.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;
import org.qas.qtest.api.internal.model.ArtifactLevel;

/**
 * CreateTestSuiteRequest
 *
 * @author Dzung Nguyen
 * @version $Id CreateTestSuiteRequest 2015-05-29 17:04:30z dzungvnguyen $
 * @since 1.0
 */
public class CreateTestSuiteRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private ArtifactLevel artifactLevel = ArtifactLevel.ROOT;
  private Long artifactId = 0L;
  private TestSuite testSuite;

  //~ class members ===========================================================
  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public CreateTestSuiteRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test cycle identifier.
   */
  public Long getArtifactId() {
    return artifactId;
  }

  /**
   * Sets the test cycle identifier where to fetch the test suites.
   *
   * @param artifactId the given test cycle identifier.
   */
  public void setArtifactId(Long artifactId) {
    this.artifactId = artifactId;
  }

  /**
   * Sets the artifact identifier where to fetch the test suites.
   *
   * @param artifactId the given artifact identifier to set.
   * @return the create test-suite request instance.
   */
  public CreateTestSuiteRequest withArtifactId(Long artifactId) {
    setArtifactId(artifactId);
    return this;
  }

  /**
   * @return the artifact level.
   */
  public ArtifactLevel getArtifactLevel() {
    return artifactLevel;
  }

  /**
   * Sets the artifact level.
   *
   * @param artifactLevel the given artifact level instance.
   */
  public void setArtifactLevel(ArtifactLevel artifactLevel) {
    this.artifactLevel = artifactLevel;
  }

  /**
   * Sets the artifact level.
   *
   * @param artifactLevel the given artifact level instance.
   * @return the create test-suite request instance.
   */
  public CreateTestSuiteRequest withArtifactLevel(ArtifactLevel artifactLevel) {
    setArtifactLevel(artifactLevel);
    return this;
  }

  /**
   * @return the test-suite instance.
   */
  public TestSuite getTestSuite() {
    return testSuite;
  }

  /**
   * Sets the test-suite instance.
   *
   * @param testSuite the given test-suite instance to set.
   */
  public void setTestSuite(TestSuite testSuite) {
    this.testSuite = testSuite;
  }

  /**
   * Sets the test-suite instance.
   *
   * @param testSuite the given test-suite instance to set.
   * @return current create test-suite request instance.
   */
  public CreateTestSuiteRequest withTestSuite(TestSuite testSuite) {
    setTestSuite(testSuite);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("CreateTestSuiteRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", artifactId=").append(artifactId);
    sb.append(", artifactLevel=").append(artifactLevel);
    sb.append(", testSuite=").append(testSuite);
    sb.append('}');
    return sb.toString();
  }
}
