package org.qas.qtest.api.services.design.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.design.model.GetTestStepRequest;

/**
 * GetTestStepRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id GetTestStepRequestMarshaller 2014-04-04 06:18:30z dungvnguyen $
 * @since 1.0
 */
public final class GetTestStepRequestMarshaller extends AbstractMarshaller<Request, GetTestStepRequest> {

  @Override
  protected void validateRequest(GetTestStepRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid argument passed to marshall(...)");
    }
    // validate project id.
    if (in.getProjectId() == null
      || in.getProjectId() <= 0) {
      throw new AuthClientException("Invalid project id passed to marshall(...)");
    }
    // validate test case id.
    if (in.getTestCaseId() == null
      || in.getTestCaseId() <= 0) {
      throw new AuthClientException("Invalid test case id passed to marshall(...)");
    }
    // validate test case version id.
    if (in.getTestCaseVersion() == null
      || in.getTestCaseVersion() <= 0) {
      throw new AuthClientException("Invalid test case version passed to marshall(...)");
    }
    // validate test step id.
    if (in.getTestStepId() == null
      || in.getTestStepId() <= 0) {
      throw new AuthClientException("Invalid test step id to passed to marshall(...)");
    }
  }

  @Override
  protected String getServiceName() {
    return "TestDesignService";
  }

  @Override
  protected String getActionName() {
    return "GetTestStep";
  }

  @Override
  protected String getContent(GetTestStepRequest in) throws Exception {
    return null;
  }

  @Override
  protected StringBuilder getResourcePath(GetTestStepRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/v3/projects/")
      .append(in.getProjectId())
      .append("/test-cases/")
      .append(in.getTestCaseId())
      .append("/versions/")
      .append(in.getTestCaseVersion())
      .append("/test-steps/")
      .append(in.getTestStepId());
  }
}
