package org.qas.qtest.api.services.design.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * ListTestCaseRequest
 *
 * @author Dzung Nguyen
 * @version $Id ListTestCaseRequest 2014-04-25 15:14:30z dungvnguyen $
 * @since 1.0
 */
public class ListTestCaseRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long moduleId;
  private Long page = 1L;
  private Long pageSize;

  //~ class members ===========================================================

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return this
   */
  public ListTestCaseRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return module identifier.
   */
  public Long getModuleId() {
    return moduleId;
  }

  /**
   * Sets the module identifier.
   *
   * @param moduleId the given module identifier to set.
   */
  public void setModuleId(Long moduleId) {
    this.moduleId = moduleId;
  }

  /**
   * Sets the module identifier.
   *
   * @param moduleId the given module identifier to set.
   * @return this
   */
  public ListTestCaseRequest withModuleId(Long moduleId) {
    setModuleId(moduleId);
    return this;
  }

  /**
   * @return the current page.
   */
  public Long getPage() {
    return page;
  }

  /**
   * Sets the current page.
   *
   * @param page the given page to set.
   */
  public void setPage(Long page) {
    this.page = page;
  }

  /**
   * Sets the current page.
   *
   * @param page the given page to set.
   * @return this
   */
  public ListTestCaseRequest withPage(Long page) {
    setPage(page);
    return this;
  }

  /**
   * @return the page size.
   */
  public Long getPageSize() {
    return pageSize;
  }

  /**
   * Sets the page size.
   *
   * @param pageSize the given page size to set.
   */
  public void setPageSize(Long pageSize) {
    this.pageSize = pageSize;
  }

  /**
   * Sets the page size.
   *
   * @param pageSize the given page size to set.
   * @return this
   */
  public ListTestCaseRequest withPageSize(Long pageSize) {
    setPageSize(pageSize);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("ListTestCaseRequest{");
    sb.append("moduleId=").append(projectId);
    sb.append(", moduleId=").append(moduleId);
    sb.append(", page=").append(page);

    if (pageSize != null) {
      sb.append(", pageSize=").append(pageSize);
    }

    sb.append('}');
    return sb.toString();
  }
}
