package org.qas.qtest.api.services.design.model;

import org.qas.api.ApiServiceRequest;

/**
 * GetTestCaseFieldsRequest
 *
 * @author Dzung Nguyen
 * @version $Id GetTestCaseFieldsRequest 2014-05-19 14:13:30z dungvnguyen $
 * @since 1.0
 */
public class GetTestCaseFieldsRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;

  //~ class members ===========================================================
  /**
   * @return the project identifier that the testcase will attach to.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier value to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets the project identifier and return itself.
   *
   * @param projectId the given project identifier value to set.
   * @return the get test case fields request instance.
   */
  public GetTestCaseFieldsRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder(getClass().getName());

    builder.append("{").append("\n")
        .append("\tprojectId: ").append(projectId).append(",").append("\n")
        .append("}");

    return builder.toString();
  }
}
