package org.qas.qtest.api.services.design.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * DeleteTestCaseRequest
 *
 * @author Dzung Nguyen
 * @version $Id DeleteTestCaseRequest 2015-06-03 17:14:30z dzungvnguyen $
 * @since 1.0
 */
public class DeleteTestCaseRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private Long testCaseId;

  //~ class members ===========================================================

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return this
   */
  public DeleteTestCaseRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test case identifier.
   */
  public Long getTestCaseId() {
    return testCaseId;
  }

  /**
   * Sets the test case identifier.
   *
   * @param testCaseId the given test case identifier to set.
   */
  public void setTestCaseId(Long testCaseId) {
    this.testCaseId = testCaseId;
  }

  /**
   * Sets the test case identifier.
   *
   * @param testCaseId the given test case identifier to set.
   * @return this
   */
  public DeleteTestCaseRequest withTestCaseId(Long testCaseId) {
    setTestCaseId(testCaseId);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("DeleteTestCaseRequest{");
    sb.append("projectId=").append(projectId);
    sb.append(", testCaseId=").append(testCaseId);
    sb.append('}');
    return sb.toString();
  }
}
