package org.qas.qtest.api.services.design.model;

import org.qas.api.ApiServiceRequest;

/**
 * CreateTestStepRequest
 *
 * @author Dzung Nguyen
 * @version $Id CreateTestStepRequest 2014-04-05 11:03:30z dungvnguyen $
 * @since 1.0
 */
public class CreateTestStepRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private Long projectId;
  private Long testCaseId;
  private TestStep testStep;

  //~ class members ===========================================================

  /**
   * @return the project identifier.
   */
  public Long getProjectId() {
    return projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   */
  public void setProjectId(Long projectId) {
    this.projectId = projectId;
  }

  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return this
   */
  public CreateTestStepRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the test case identifier.
   */
  public Long getTestCaseId() {
    return testCaseId;
  }

  /**
   * Sets the test case identifier.
   *
   * @param testCaseId the given test case identifier to set.
   */
  public void setTestCaseId(Long testCaseId) {
    this.testCaseId = testCaseId;
  }

  /**
   * Sets the test case identifier.
   *
   * @param testCaseId the given test case identifier to set.
   * @return this
   */
  public CreateTestStepRequest withTestCaseId(Long testCaseId) {
    setTestCaseId(testCaseId);
    return this;
  }

  /**
   * @return the test sep instance.
   */
  public TestStep getTestStep() {
    return testStep;
  }

  /**
   * Sets the test step instance.
   *
   * @param testStep the given test step instance to set.
   */
  public void setTestStep(TestStep testStep) {
    this.testStep = testStep;
  }

  /**
   * Sets the test step instance.
   *
   * @param testStep the given test step instance to set.
   * @return this
   */
  public CreateTestStepRequest withTestStep(TestStep testStep) {
    setTestStep(testStep);
    return this;
  }
}
