package org.qas.qtest.api.services.design.model;

import org.qas.qtest.api.internal.model.AbstractQTestApiServiceRequest;

/**
 * CreateAutomationTestCaseRequest
 *
 * @author Thong Nguyen
 * @version $Id CreateAutomationTestCaseRequest 2015-03-14 22:49:30z dungnguyen $
 * @since 1.0
 */
public class CreateAutomationTestCaseRequest extends AbstractQTestApiServiceRequest {
  //~ class properties ========================================================
  private AutomationTestCase automationTestCase;

  //~ class members ===========================================================
  /**
   * Sets the project identifier.
   *
   * @param projectId the given project identifier to set.
   * @return the {@link CreateAutomationTestCaseRequest} instance.
   */
  public CreateAutomationTestCaseRequest withProjectId(Long projectId) {
    setProjectId(projectId);
    return this;
  }

  /**
   * @return the {@link AutomationTestCase} instance.
   */
  public AutomationTestCase getAutomationTestCase() {
    return automationTestCase;
  }

  /**
   * Sets the {@link AutomationTestCase} instance.
   *
   * @param automationTestCase the given {@link AutomationTestCase} instance to set.
   */
  public void setAutomationTestCase(AutomationTestCase automationTestCase) {
    this.automationTestCase = automationTestCase;
  }

  /**
   * Sets the {@link AutomationTestCase} instance.
   *
   * @param automationTestCase the given {@link AutomationTestCase} instance to set.
   * @return the {@link CreateAutomationTestCaseRequest} instance.
   */
  public CreateAutomationTestCaseRequest withAutomationTestCase(AutomationTestCase automationTestCase) {
    setAutomationTestCase(automationTestCase);
    return this;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder(getClass().getName());

    builder.append("{").append("\n")
        .append("\tprojectId: ").append(projectId).append(",").append("\n")
        .append("\tautomationTestCase: ").append(automationTestCase).append("\n")
        .append("}");

    return builder.toString();
  }
}
