package org.qas.qtest.api.services.defect;

import org.qas.api.AuthServiceException;
import org.qas.qtest.api.internal.QTestService;
import org.qas.qtest.api.internal.model.CreateObjectCommentRequest;
import org.qas.qtest.api.services.defect.model.CreateDefectRequest;
import org.qas.qtest.api.services.defect.model.Defect;

/**
 * DefectService
 *
 * @author Dzung Nguyen
 * @version $Id DefectService 2014-07-16 14:33:30z dungvnguyen $
 * @since 1.0
 */
public interface DefectService extends QTestService {
  /**
   * Creates defect from the given {@link CreateDefectRequest} instance.
   *
   * @param createDefectRequest the given {@link CreateDefectRequest} instance.
   * @return the {@link Defect} instance.
   * @throws AuthServiceException if an error occurs during creating request.
   */
  Defect createDefect(CreateDefectRequest createDefectRequest) throws AuthServiceException;

  /**
   * Creates defect comment from the given request.
   *
   * @param createObjectCommentRequest the given {@link CreateObjectCommentRequest} instance.
   * @return the {@link Defect} instance.
   * @throws AuthServiceException if an error occurs during creating defect comment.
   */
  Defect addComment(CreateObjectCommentRequest createObjectCommentRequest) throws AuthServiceException;
}
