package org.qas.qtest.api.services.client.model.transform;

import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.transform.AbstractMarshaller;
import org.qas.qtest.api.services.client.model.GetClientRequest;

/**
 * GetClientRequestMarshaller
 *
 * @author Dzung Nguyen
 * @version $Id GetClientRequestMarshaller 2014-11-11 15:19:30z dungvnguyen $
 * @since 1.0
 */
public final class GetClientRequestMarshaller extends AbstractMarshaller<Request, GetClientRequest> {

  @Override
  protected void validateRequest(GetClientRequest in) throws Exception {
    if (in == null) {
      throw new AuthClientException("Invalid argument passed to call(...)");
    }
    if (in.getClientId() == null) {
      throw new AuthClientException("Invalid clientId value passed to call(...)");
    }
  }

  @Override
  protected String getServiceName() {
    return "ClientService";
  }

  @Override
  protected String getActionName() {
    return "GetClient";
  }

  @Override
  protected String getContent(GetClientRequest in) throws Exception {
    return null;
  }

  @Override
  protected StringBuilder getResourcePath(GetClientRequest in, StringBuilder rpBuilder) {
    return rpBuilder.append("/api/v3/clients/")
      .append(in.getClientId());
  }
}
