package org.qas.qtest.api.services.client;

import org.qas.api.AuthServiceException;
import org.qas.api.handler.AsyncHandler;
import org.qas.qtest.api.services.client.model.Client;
import org.qas.qtest.api.services.client.model.GetClientRequest;
import org.qas.qtest.api.services.client.model.SetSessionUrlRequest;

import java.util.concurrent.Future;

/**
 * ClientServiceAsync
 *
 * @author Dzung Nguyen
 * @version $Id ClientServiceAsync 2014-11-11 13:48:30z dungvnguyen $
 * @since 1.0
 */
public interface ClientServiceAsync extends ClientService {
  /**
   * Get client from the given {@link GetClientRequest client request} instance.
   *
   * @param getClientRequest the given {@link GetClientRequest client request} instance.
   * @return the {@link Client} instance.
   * @throws org.qas.api.AuthServiceException if an error occurs during getting client.
   */
  Future<Client> getClientAsync(GetClientRequest getClientRequest) throws AuthServiceException;

  /**
   * Get client from the given {@link GetClientRequest client request} instance.
   *
   * @param getClientRequest the given {@link GetClientRequest client request} instance.
   * @param asyncHandler callback handler for events in the life-cycle of the request.
   *                     Users could provide the implementation of the for callback
   *                     methods in this interface to process the operation result or
   *                     handle the exception.
   * @return the {@link Client} instance.
   * @throws org.qas.api.AuthServiceException if an error occurs during getting client.
   */
  Future<Client> getClientAsync(GetClientRequest getClientRequest,
                                AsyncHandler<GetClientRequest, Client> asyncHandler) throws AuthServiceException;

  /**
   * Sets the session URL from the given {@link SetSessionUrlRequest set session URL}
   *
   * @param setSessionUrlRequest the given {@link SetSessionUrlRequest set session URL request} instance.
   * @throws AuthServiceException if an error occurs during set session URL.
   */
  Future<Void> setSessionUrlAsync(SetSessionUrlRequest setSessionUrlRequest) throws AuthServiceException;

  /**
   * Sets the session URL from the given {@link SetSessionUrlRequest set session URL}
   *
   * @param setSessionUrlRequest the given {@link SetSessionUrlRequest set session URL request} instance.
   * @param asyncHandler callback handler for events in the life-cycle of the request.
   *                     Users could provide the implementation of the for callback
   *                     methods in this interface to process the operation result or
   *                     handle the exception.
   * @throws AuthServiceException if an error occurs during set session URL.
   */
  Future<Void> setSessionUrlAsync(SetSessionUrlRequest setSessionUrlRequest,
                                  AsyncHandler<SetSessionUrlRequest, Void> asyncHandler) throws AuthServiceException;
}
