package org.qas.qtest.api.services.authenticate.model;

import org.qas.api.ApiServiceRequest;

/**
 * ValidateTokenRequest
 *
 * @author Dzung Nguyen
 * @version $Id ValidateTokenRequest 2014-07-10 11:09:30z dungvnguyen $
 * @since 1.0
 */
public class ValidateTokenRequest extends ApiServiceRequest {
  //~ class properties ========================================================
  private String token;

  //~ class members ===========================================================
  /**
   * @return the authenticate token.
   */
  public String getToken() {
    return token;
  }

  /**
   * Sets the authenticate token.
   *
   * @param token the given authenticate token to set.
   */
  public void setToken(String token) {
    this.token = token;
  }

  /**
   * Sets the authenticate token and return current instance.
   *
   * @param token the given authenticate token to set.
   * @return current instance.
   */
  public ValidateTokenRequest withToken(String token) {
    setToken(token);
    return this;
  }

  @Override
  public String toString() {
    final StringBuilder sb = new StringBuilder("ValidateTokenRequest{\n");
    sb.append("\ttoken: ").append(token).append(",\n");
    sb.append('}');
    return sb.toString();
  }
}
