package org.qas.qtest.api.services.attachment.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.transform.AbstractUnmarshaller;
import org.qas.api.transform.JsonUnmarshallerContext;
import org.qas.qtest.api.services.attachment.model.Attachment;

/**
 * AttachmentJsonUnmarshaller
 *
 * @author Dzung Nguyen
 * @version $Id AttachmentJsonUnmarshaller 2014-03-29 05:16:30z dungvnguyen $
 * @since 1.0
 */
public final class AttachmentJsonUnmarshaller extends AbstractUnmarshaller<Attachment, JsonUnmarshallerContext> {
  //~ class properties ========================================================
  private static AttachmentJsonUnmarshaller instance;

  //~ class members ===========================================================
  public static AttachmentJsonUnmarshaller getInstance() {
    if (instance == null) instance = new AttachmentJsonUnmarshaller();
    return instance;
  }

  @Override
  public Attachment parse(String data) throws Exception {
    return JsonMapper.parseJson(data, Attachment.class);
  }
}
