package org.qas.api.transform;

import com.fasterxml.jackson.core.type.TypeReference;
import org.qas.api.JsonMapper;

/**
 * @author trongle
 * @version $Id 4/21/2017 5:07 PM
 */
public abstract class AbstractUnmarshaller<T, R> implements Unmarshaller<T, R> {
  @Override
  public boolean isParseJson() {
    return true;
  }

  @Override
  public T unmarshall(R in) throws Exception {
    return null;
  }
  
  @Override
  public T parse(String data) throws Exception {
    return JsonMapper.parseJson(data, new TypeReference<T>() {
    });
  }
}
