package org.qas.api.http;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;

/**
 * HttpResponse
 *
 * @author: Dzung Nguyen
 * @version: $Id HttpResponse 2014-03-26 15:42:30z dungvnguyen $
 * @since 1.0
 */
public interface HttpResponse<T> {
  /**
   * Returns the HTTP response status code.
   *
   * @return the HTTP response status code.
   * @throws IOException if an error occurs during retrieving status code.
   */
  int getStatusCode() throws IOException;

  /**
   * Returns the HTTP response status message.
   *
   * @return the HTTP response status message.
   * @throws IOException if an error occurs during retrieving status text.
   */
  String getStatus() throws IOException;

  /**
   * Returns the HTTP response as {@link InputStream} object.
   *
   * @return the HTTP response as {@link InputStream} object.
   * @throws IOException if an error occurs during getting content.
   */
  InputStream getContent() throws IOException;

  /**
   * @return the underlying response object, in case you need to work on it
   *         directly.
   */
  T getUnderlying();

  /**
   * @return the original request associated with this response.
   */
  HttpRequest<T> getRequest();

  /**
   * @return the HTTP response headers.
   */
  Map<String, String> getHeaders();

  /**
   * Close the connection.
   */
  void close();
}
