package org.qas.api.http;

import org.qas.api.ClientConfiguration;

/**
 * AbstractHttpAuthClient
 *
 * @author Dzung Nguyen
 * @version $Id AbstractHttpAuthClient 2014-03-27 11:44:30z dungvnguyen $
 * @since 1.0
 */
public abstract class AbstractHttpAuthClient<T> implements HttpAuthClient<T> {
  //~ class properties ========================================================
  private final ClientConfiguration configuration;

  //~ class members ===========================================================
  /**
   * Creates the concrete class from the specified client configuration.
   *
   * @param configuration the specified client configuration object.
   */
  protected AbstractHttpAuthClient(ClientConfiguration configuration) {
    this.configuration = configuration;
  }

  /**
   * @return the specified client configuration object.
   */
  protected ClientConfiguration getConfiguration() {
    return configuration;
  }
}
