/*
 * Decompiled with CFR 0.152.
 */
package com.q42.qlassified;

import android.content.Context;
import android.os.Build;
import android.util.Log;
import com.q42.qlassified.Entry.EncryptedEntry;
import com.q42.qlassified.Entry.QlassifiedBoolean;
import com.q42.qlassified.Entry.QlassifiedEntry;
import com.q42.qlassified.Entry.QlassifiedFloat;
import com.q42.qlassified.Entry.QlassifiedInteger;
import com.q42.qlassified.Entry.QlassifiedLong;
import com.q42.qlassified.Entry.QlassifiedSerializable;
import com.q42.qlassified.Entry.QlassifiedString;
import com.q42.qlassified.Provider.QlassifiedGuard;
import com.q42.qlassified.Provider.QlassifiedKeyStore;
import com.q42.qlassified.Provider.QlassifiedSecurity;
import com.q42.qlassified.Storage.QlassifiedStorageService;
import java.io.IOException;
import java.io.Serializable;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class QlassifiedFactory {
    private Context context;
    private QlassifiedSecurity keyStore;
    private QlassifiedStorageService storageService;

    public void create(Context context) {
        this.context = context;
        this.getKeyStore(context);
    }

    private boolean getKeyStore(Context context) {
        try {
            this.keyStore = Build.VERSION.SDK_INT >= 18 ? new QlassifiedKeyStore(context) : new QlassifiedGuard();
        }
        catch (IOException | KeyStoreException | NoSuchAlgorithmException | CertificateException e) {
            Log.e((String)"Qlassified", (String)String.format("The Keystore could not be created. Stacktrace: %s", e));
            return false;
        }
        return true;
    }

    public void setStorageService(QlassifiedStorageService storageService) {
        this.storageService = storageService;
    }

    public boolean put(QlassifiedEntry entry) {
        if (!this.instanceCheck()) {
            return false;
        }
        EncryptedEntry encryptedEntry = this.keyStore.encryptEntry(entry);
        this.storageService.onSaveRequest(encryptedEntry);
        return true;
    }

    private Object get(String key) {
        if (key == null || !this.instanceCheck()) {
            return null;
        }
        EncryptedEntry encryptedEntry = this.storageService.onGetRequest(key);
        return this.keyStore.decryptEntry(encryptedEntry);
    }

    public Boolean getBoolean(String key) {
        QlassifiedBoolean entry = (QlassifiedBoolean)this.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Float getFloat(String key) {
        QlassifiedFloat entry = (QlassifiedFloat)this.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Integer getInt(String key) {
        QlassifiedInteger entry = (QlassifiedInteger)this.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Long getLong(String key) {
        QlassifiedLong entry = (QlassifiedLong)this.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public String getString(String key) {
        QlassifiedString entry = (QlassifiedString)this.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    public Serializable getSerializable(String key) {
        QlassifiedSerializable entry = (QlassifiedSerializable)this.get(key);
        if (entry == null) {
            return null;
        }
        return entry.getValue();
    }

    private boolean instanceCheck() {
        return (this.keyStore != null || this.getKeyStore(this.context)) && this.storageService != null;
    }
}

