/*
 * Decompiled with CFR 0.152.
 */
package com.example.networklibrary.network.data.inherit;

import android.text.TextUtils;
import com.example.networklibrary.network.data.inherit.ResponseValidator;
import com.google.gson.annotations.SerializedName;
import java.util.HashMap;

public class Response
extends ResponseValidator {
    private static final String KEY_AUTHENTICATION = "Authentication";
    private static final String KEY_ACCESS = "Access";
    private static final String KEY_SYSTEM = "System";
    private static final String KEY_VERSION = "version";
    @SerializedName(value="status")
    private Boolean status;
    @SerializedName(value="error")
    private HashMap<String, String[]> errors;

    public Boolean getStatus() {
        return this.status;
    }

    public boolean hasErrors() {
        return this.errors != null;
    }

    public Type getErrorType() {
        Type type = !this.hasErrors() ? Type.NONE : (this.errors.containsKey(KEY_AUTHENTICATION) ? Type.AUTHENTICATION : (this.errors.containsKey(KEY_VERSION) ? Type.VERSION : (this.errors.containsKey(KEY_ACCESS) ? Type.ACCESS : (this.errors.containsKey(KEY_SYSTEM) ? Type.SYSTEM : Type.UNKNOWN))));
        return type;
    }

    public String generateErrorMessage() {
        if (!this.hasErrors()) {
            return "No errors found";
        }
        String message = null;
        for (String key : this.errors.keySet()) {
            for (String reason : this.errors.get(key)) {
                message = TextUtils.isEmpty(message) ? reason : message.concat("\n" + reason);
            }
        }
        return message;
    }

    public static enum Type {
        AUTHENTICATION,
        ACCESS,
        SYSTEM,
        VERSION,
        NONE,
        UNKNOWN;

    }
}

