/*
 * Decompiled with CFR 0.152.
 */
package com.example.networklibrary.network.manager;

import android.app.Activity;
import android.content.ContentResolver;
import android.content.Context;
import android.content.Intent;
import android.content.SharedPreferences;
import android.net.Uri;
import android.preference.PreferenceManager;
import android.provider.Settings;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.util.Log;
import android.view.View;
import com.android.volley.Request;
import com.android.volley.RequestQueue;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.Volley;
import com.example.networklibrary.NetworkBaseUrl;
import com.example.networklibrary.R;
import com.example.networklibrary.network.data.inherit.Response;
import com.example.networklibrary.network.parsing.GsonRequest;
import com.example.networklibrary.views.CustomSnackbar;
import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.util.HashMap;
import java.util.Map;

public class NetworkHelper<T> {
    private static final String TAG = NetworkHelper.class.getSimpleName();
    private Context context;
    private RequestQueue requestQueue;

    public NetworkHelper(Context context) {
        this.context = context.getApplicationContext();
        this.requestQueue = Volley.newRequestQueue((Context)context);
    }

    protected Context getContext() {
        return this.context;
    }

    protected void addToQueue(Request request) {
        Log.d((String)TAG, (String)("Sending request: " + request.getUrl()));
        this.requestQueue.add(request);
    }

    protected void cancelRequests(Object tag) {
        this.requestQueue.cancelAll(tag);
    }

    protected void createAndMakeGsonRequest(@NonNull Object requestTag, @NonNull MethodType type, @NonNull String endpoint, @Nullable T bodyParams, Class<T> responseClass, @Nullable Callback callback) {
        GsonRequest request = this.createGsonRequest(requestTag, type, endpoint, bodyParams, responseClass, callback);
        this.addToQueue(request);
    }

    protected GsonRequest createGsonRequest(final @NonNull Object requestTag, @NonNull MethodType type, @NonNull String endpoint, @Nullable T bodyParams, final Class<T> responseClass, final @Nullable Callback callback) {
        int methodType;
        String url = NetworkBaseUrl.getBaseUrl() + endpoint;
        switch (type) {
            case GET: {
                methodType = 0;
                break;
            }
            case POST: {
                methodType = 1;
                break;
            }
            case PUT: {
                methodType = 2;
                break;
            }
            default: {
                methodType = 0;
            }
        }
        GsonRequest<T, T> request = new GsonRequest<T, T>(methodType, url, bodyParams, responseClass, this.getHeaders(), new Response.Listener(){

            public void onResponse(Object response) {
                NetworkHelper.this.handleResponse(requestTag, response, callback, false);
            }
        }, new Response.ErrorListener(){

            public void onErrorResponse(VolleyError error) {
                Object response;
                boolean invalidData = false;
                try {
                    if (error.getCause() instanceof JsonParseException) {
                        Log.e((String)TAG, (String)"parsing error", (Throwable)error.getCause());
                        invalidData = true;
                        response = null;
                    } else {
                        Log.e((String)TAG, (String)"error", (Throwable)error);
                        response = new Gson().fromJson(new String(error.networkResponse.data), responseClass);
                    }
                }
                catch (Throwable e) {
                    Log.e((String)TAG, (String)"error", (Throwable)e);
                    response = null;
                }
                NetworkHelper.this.handleResponse(requestTag, response, callback, invalidData);
            }
        });
        request.setTag(requestTag);
        return request;
    }

    private Map<String, String> getHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences((Context)this.context);
        headers.put("Accept", "application/json, application/json.v2");
        if (prefs.contains("auth_key")) {
            headers.put("X-API-KEY", prefs.getString("auth_key", ""));
        }
        headers.put("X-DEV-UUID", Settings.Secure.getString((ContentResolver)this.context.getContentResolver(), (String)"android_id"));
        return headers;
    }

    private void handleResponse(@NonNull Object requestTag, @Nullable Object responseObject, @Nullable Callback callback, @NonNull boolean invalidData) {
        Response response = (Response)responseObject;
        Status status = invalidData ? Status.ERROR_INVALID_DATA : (response == null ? Status.ERROR_NETWORK : (response.getStatus() == false || response.hasErrors() ? Status.ERROR_SERVER : Status.SUCCESS));
        if (callback != null && !callback.onComplete(status, responseObject)) {
            View rootView = null;
            if (requestTag instanceof Fragment) {
                rootView = ((Fragment)requestTag).getView();
            } else if (requestTag instanceof Activity) {
                rootView = ((Activity)requestTag).findViewById(0x1020002);
            }
            if (status != Status.SUCCESS && rootView != null) {
                this.showSnackbarError(rootView, status, response);
            }
        }
    }

    private void showSnackbarError(@NonNull View rootView, @NonNull Status status, @Nullable Response response) {
        CustomSnackbar snackbar = new CustomSnackbar(this.context, rootView);
        snackbar.setMessageColor(R.color.white);
        snackbar.setActionColor(R.color.button_positive);
        switch (status) {
            case ERROR_NETWORK: {
                snackbar.setMessage(R.string.snackbar_network_message);
                break;
            }
            case ERROR_SERVER: {
                switch (response.getErrorType()) {
                    case ACCESS: {
                        snackbar.setMessage(R.string.snackbar_server_access);
                        snackbar.setAction(R.string.snackbar_action_log_in, new View.OnClickListener(){

                            public void onClick(View v) {
                                NetworkBaseUrl.clearData();
                                NetworkBaseUrl.restartApp();
                            }
                        });
                        break;
                    }
                    case AUTHENTICATION: {
                        snackbar.setDuration(-2);
                        snackbar.setMessage(R.string.snackbar_server_authentication);
                        snackbar.setAction(R.string.snackbar_action_log_in, new View.OnClickListener(){

                            public void onClick(View v) {
                                NetworkBaseUrl.clearData();
                                NetworkBaseUrl.restartApp();
                            }
                        });
                        break;
                    }
                    case SYSTEM: {
                        if (response.hasErrors()) {
                            snackbar.setMessage(response.generateErrorMessage());
                            break;
                        }
                        snackbar.setMessage(R.string.snackbar_server_system);
                        break;
                    }
                    case VERSION: {
                        if (response.hasErrors()) {
                            snackbar.setMessage(response.generateErrorMessage());
                        } else {
                            snackbar.setMessage(R.string.update_message);
                        }
                        snackbar.setAction(R.string.update, new View.OnClickListener(){

                            public void onClick(View view) {
                                Context context = NetworkHelper.this.getContext();
                                if (context == null) {
                                    return;
                                }
                                String packageName = context.getPackageName();
                                try {
                                    context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("market://details?id=" + packageName))));
                                }
                                catch (Throwable e) {
                                    context.startActivity(new Intent("android.intent.action.VIEW", Uri.parse((String)("https://play.google.com/store/apps/details?id=" + packageName))));
                                }
                            }
                        });
                        break;
                    }
                    case UNKNOWN: {
                        if (response.hasErrors()) {
                            snackbar.setMessage(response.generateErrorMessage());
                            break;
                        }
                        snackbar.setMessage(R.string.snackbar_server_message);
                    }
                }
                break;
            }
            case ERROR_INVALID_DATA: {
                snackbar.setMessage(R.string.snackbar_data_message);
                break;
            }
            default: {
                snackbar.setMessage(R.string.snackbar_server_message);
            }
        }
        snackbar.show();
    }

    public static interface Callback<T> {
        public boolean onComplete(@NonNull Status var1, @Nullable T var2);
    }

    public static enum Status {
        SUCCESS,
        ERROR_INVALID_DATA,
        ERROR_SERVER,
        ERROR_NETWORK,
        UNKNOWN;

    }

    protected static enum MethodType {
        GET,
        POST,
        PUT;

    }
}

