/*
 * Decompiled with CFR 0.152.
 */
package com.pyamsoft.pydroid.loader.glide;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.view.View;
import android.widget.ImageView;
import androidx.annotation.CheckResult;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.CustomViewTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.pyamsoft.pydroid.loader.GenericLoader;
import com.pyamsoft.pydroid.loader.ImageTarget;
import com.pyamsoft.pydroid.loader.Loaded;
import com.pyamsoft.pydroid.loader.glide.GlideLoaded;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000<\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b \u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u000f\b\u0004\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00028\u00000\n2\u0006\u0010\u000b\u001a\u00020\fH%J\u0016\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0010H\u0003J\u000e\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u0012\u001a\u00020\u0013J\u0014\u0010\u0011\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00028\u00000\u0014R\u0014\u0010\u0004\u001a\u00020\u0005X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\u0015"}, d2={"Lcom/pyamsoft/pydroid/loader/glide/GlideLoader;", "T", "", "Lcom/pyamsoft/pydroid/loader/GenericLoader;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "getContext", "()Landroid/content/Context;", "createRequest", "Lcom/bumptech/glide/RequestBuilder;", "request", "Lcom/bumptech/glide/RequestManager;", "glideLoad", "Lcom/pyamsoft/pydroid/loader/Loaded;", "target", "Lcom/bumptech/glide/request/target/Target;", "into", "imageView", "Landroid/widget/ImageView;", "Lcom/pyamsoft/pydroid/loader/ImageTarget;", "loader_release"})
public abstract class GlideLoader<T>
extends GenericLoader<T> {
    @NotNull
    private final Context context;

    @CheckResult
    @NotNull
    protected abstract RequestBuilder<T> createRequest(@NotNull RequestManager var1);

    @Override
    @NotNull
    public final Loaded into(@NotNull ImageView imageView) {
        Intrinsics.checkNotNullParameter((Object)imageView, (String)"imageView");
        return this.glideLoad((Target)new CustomViewTarget<ImageView, T>(this, imageView, (View)imageView){
            final /* synthetic */ GlideLoader this$0;
            final /* synthetic */ ImageView $imageView;

            protected void onResourceCleared(@Nullable Drawable placeholder) {
                this.$imageView.setImageDrawable(null);
            }

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                this.$imageView.setImageDrawable(null);
                GlideLoader.access$notifyError(this.this$0);
            }

            protected void onResourceLoading(@Nullable Drawable placeholder) {
                GlideLoader.access$notifyLoading(this.this$0);
            }

            public void onResourceReady(@NotNull T resource, @Nullable Transition<? super T> transition) {
                Intrinsics.checkNotNullParameter(resource, (String)"resource");
                Object mutated = GlideLoader.access$executeMutator(this.this$0, GlideLoader.access$mutateImage(this.this$0, resource));
                GlideLoader.access$setImage(this.this$0, this.$imageView, mutated);
                GlideLoader.access$notifySuccess(this.this$0, mutated);
            }
            {
                this.this$0 = this$0;
                this.$imageView = $captured_local_variable$1;
                super($super_call_param$2);
            }
        });
    }

    @Override
    @NotNull
    public final Loaded into(@NotNull ImageTarget<T> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        return this.glideLoad((Target)new CustomTarget<T>(this, target){
            final /* synthetic */ GlideLoader this$0;
            final /* synthetic */ ImageTarget $target;

            public void onLoadCleared(@Nullable Drawable placeholder) {
                this.$target.clear();
            }

            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                this.$target.clear();
                GlideLoader.access$notifyError(this.this$0);
            }

            public void onLoadStarted(@Nullable Drawable placeholder) {
                GlideLoader.access$notifyLoading(this.this$0);
            }

            public void onResourceReady(@NotNull T resource, @Nullable Transition<? super T> transition) {
                Intrinsics.checkNotNullParameter(resource, (String)"resource");
                Object mutated = GlideLoader.access$executeMutator(this.this$0, GlideLoader.access$mutateImage(this.this$0, resource));
                this.$target.setImage(mutated);
                GlideLoader.access$notifySuccess(this.this$0, mutated);
            }
            {
                this.this$0 = this$0;
                this.$target = $captured_local_variable$1;
            }
        });
    }

    @CheckResult
    private final Loaded glideLoad(Target<T> target) {
        RequestManager requestManager = Glide.with((Context)this.context.getApplicationContext());
        Intrinsics.checkNotNullExpressionValue((Object)requestManager, (String)"Glide.with(context.applicationContext)");
        RequestManager manager = requestManager;
        this.createRequest(manager).into(target);
        return new GlideLoaded(manager, target);
    }

    @NotNull
    protected final Context getContext() {
        return this.context;
    }

    protected GlideLoader(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
    }

    public static final /* synthetic */ void access$notifyError(GlideLoader $this) {
        $this.notifyError();
    }

    public static final /* synthetic */ void access$notifyLoading(GlideLoader $this) {
        $this.notifyLoading();
    }

    public static final /* synthetic */ Object access$executeMutator(GlideLoader $this, Object data) {
        return $this.executeMutator(data);
    }

    public static final /* synthetic */ Object access$mutateImage(GlideLoader $this, Object resource) {
        return $this.mutateImage(resource);
    }

    public static final /* synthetic */ void access$setImage(GlideLoader $this, ImageView view, Object image) {
        $this.setImage(view, image);
    }

    public static final /* synthetic */ void access$notifySuccess(GlideLoader $this, Object result) {
        $this.notifySuccess(result);
    }
}

