/*
 * Decompiled with CFR 0.152.
 */
package com.pyamsoft.pydroid.loader.glide;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.widget.ImageView;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.RequestManager;
import com.pyamsoft.pydroid.loader.glide.GlideLoader;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 1}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0014J\n\u0010\f\u001a\u0004\u0018\u00010\u0002H\u0014J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u0002H\u0014J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0002H\u0014R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/pyamsoft/pydroid/loader/glide/GlideByteArrayLoader;", "Lcom/pyamsoft/pydroid/loader/glide/GlideLoader;", "Landroid/graphics/Bitmap;", "context", "Landroid/content/Context;", "data", "", "(Landroid/content/Context;[B)V", "createRequest", "Lcom/bumptech/glide/RequestBuilder;", "request", "Lcom/bumptech/glide/RequestManager;", "immediateResource", "mutateImage", "resource", "setImage", "", "view", "Landroid/widget/ImageView;", "image", "loader_release"})
public final class GlideByteArrayLoader
extends GlideLoader<Bitmap> {
    private final byte[] data;

    @Override
    @NotNull
    protected RequestBuilder<Bitmap> createRequest(@NotNull RequestManager request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        RequestBuilder requestBuilder = request.asBitmap().load(this.data);
        Intrinsics.checkNotNullExpressionValue((Object)requestBuilder, (String)"request\n            .asB\u2026)\n            .load(data)");
        return requestBuilder;
    }

    @Override
    @NotNull
    protected Bitmap mutateImage(@NotNull Bitmap resource) {
        Intrinsics.checkNotNullParameter((Object)resource, (String)"resource");
        Bitmap bitmap = resource.copy(resource.getConfig(), true);
        Intrinsics.checkNotNullExpressionValue((Object)bitmap, (String)"resource.copy(resource.config, true)");
        return bitmap;
    }

    @Override
    protected void setImage(@NotNull ImageView view, @NotNull Bitmap image) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)image, (String)"image");
        view.setImageBitmap(image);
    }

    @Override
    @Nullable
    protected Bitmap immediateResource() {
        return BitmapFactory.decodeByteArray((byte[])this.data, (int)0, (int)this.data.length);
    }

    public GlideByteArrayLoader(@NotNull Context context, @NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        super(context);
        this.data = data;
    }
}

