/*
 * Decompiled with CFR 0.152.
 */
package com.pyamsoft.pydroid.loader.resource;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.widget.ImageView;
import androidx.annotation.CheckResult;
import androidx.annotation.DrawableRes;
import androidx.appcompat.content.res.AppCompatResources;
import com.pyamsoft.pydroid.loader.GenericLoader;
import com.pyamsoft.pydroid.loader.cache.ImageCache;
import com.pyamsoft.pydroid.loader.loaded.Loaded;
import com.pyamsoft.pydroid.loader.targets.DrawableImageTarget;
import com.pyamsoft.pydroid.loader.targets.Target;
import com.pyamsoft.pydroid.util.DrawableKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\b&\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B7\b\u0004\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\b\b\u0001\u0010\u0005\u001a\u00020\u0006\u0012\b\b\u0001\u0010\u0007\u001a\u00020\u0006\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000e\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0014\u0010\f\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u0011J \u0010\u0012\u001a\u00020\r2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00020\u00112\b\b\u0001\u0010\u0005\u001a\u00020\u0006H%J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0002H\u0005J\n\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0003J\b\u0010\u0015\u001a\u00020\u0002H\u0003J\b\u0010\u0016\u001a\u00020\u0002H\u0005J\u0012\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00060\u0018*\u00020\u0006H\u0003R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/pyamsoft/pydroid/loader/resource/ResourceLoader;", "Lcom/pyamsoft/pydroid/loader/GenericLoader;", "Landroid/graphics/drawable/Drawable;", "context", "Landroid/content/Context;", "resource", "", "errorResource", "resourceImageCache", "Lcom/pyamsoft/pydroid/loader/cache/ImageCache;", "(Landroid/content/Context;IILcom/pyamsoft/pydroid/loader/cache/ImageCache;)V", "appContext", "into", "Lcom/pyamsoft/pydroid/loader/loaded/Loaded;", "imageView", "Landroid/widget/ImageView;", "target", "Lcom/pyamsoft/pydroid/loader/targets/Target;", "load", "loadErrorResource", "loadFreshErrorResource", "loadFreshResource", "loadResource", "toKey", "Lcom/pyamsoft/pydroid/loader/cache/ImageCache$ImageCacheKey;", "loader_release"})
public abstract class ResourceLoader
extends GenericLoader<Drawable> {
    private final Context appContext;
    private final int resource;
    private final int errorResource;
    private final ImageCache<Integer, Drawable> resourceImageCache;

    @CheckResult
    private final ImageCache.ImageCacheKey<Integer> toKey(int $receiver) {
        return new ImageCache.ImageCacheKey<Integer>($receiver);
    }

    @Override
    @NotNull
    public final Loaded into(@NotNull ImageView imageView) {
        Intrinsics.checkParameterIsNotNull((Object)imageView, (String)"imageView");
        return this.into((Target<? super Drawable>)DrawableImageTarget.Companion.forImageView(imageView));
    }

    @Override
    @NotNull
    public final Loaded into(@NotNull Target<? super Drawable> target) {
        Intrinsics.checkParameterIsNotNull(target, (String)"target");
        return this.load(target, this.resource);
    }

    @CheckResult
    @NotNull
    protected final Drawable loadResource() {
        ImageCache.ImageCacheKey<Integer> key = this.toKey(this.resource);
        Drawable cached = this.resourceImageCache.retrieve(key);
        if (cached == null) {
            Drawable result = this.loadFreshResource();
            this.resourceImageCache.cache(key, result);
            return result;
        }
        return cached;
    }

    @CheckResult
    private final Drawable loadFreshResource() {
        Drawable possiblyLoaded = AppCompatResources.getDrawable((Context)this.appContext, (int)this.resource);
        if (possiblyLoaded == null) {
            throw (Throwable)new NullPointerException("AppCompatResources failed to find drawable: " + this.resource);
        }
        if (this.getTint() != 0) {
            return DrawableKt.tintWith((Drawable)possiblyLoaded, (Context)this.appContext, (int)this.getTint());
        }
        return possiblyLoaded;
    }

    @CheckResult
    @Nullable
    protected final Drawable loadErrorResource() {
        ImageCache.ImageCacheKey<Integer> key = this.toKey(this.errorResource);
        Drawable cached = this.resourceImageCache.retrieve(key);
        if (cached == null) {
            Drawable result = this.loadFreshErrorResource();
            if (result != null) {
                this.resourceImageCache.cache(key, result);
            }
            return result;
        }
        return cached;
    }

    @CheckResult
    private final Drawable loadFreshErrorResource() {
        int n = this.errorResource;
        int it = n;
        if (it == 0) {
            return null;
        }
        return AppCompatResources.getDrawable((Context)this.appContext, (int)it);
    }

    @CheckResult
    @NotNull
    protected abstract Loaded load(@NotNull Target<? super Drawable> var1, @DrawableRes int var2);

    protected ResourceLoader(@NotNull Context context, @DrawableRes int resource, @DrawableRes int errorResource, @NotNull ImageCache<? super Integer, Drawable> resourceImageCache) {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull(resourceImageCache, (String)"resourceImageCache");
        this.resource = resource;
        this.errorResource = errorResource;
        this.resourceImageCache = resourceImageCache;
        Context context2 = context.getApplicationContext();
        Intrinsics.checkExpressionValueIsNotNull((Object)context2, (String)"context.applicationContext");
        this.appContext = context2;
        if (this.resource == 0) {
            throw (Throwable)new IllegalStateException("No resource to load");
        }
    }
}

