/*
 * Decompiled with CFR 0.152.
 */
package com.pyamsoft.pydroid.core.cache;

import androidx.annotation.CheckResult;
import com.pyamsoft.pydroid.core.cache.Repository;
import com.pyamsoft.pydroid.core.cache.RepositoryKt;
import com.pyamsoft.pydroid.core.cache.RepositoryMap;
import io.reactivex.Scheduler;
import io.reactivex.Single;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0000\u0018\u0000*\n\b\u0000\u0010\u0001 \u0000*\u00020\u0002*\b\b\u0001\u0010\u0003*\u00020\u00022\u000e\u0012\u0004\u0012\u0002H\u0001\u0012\u0004\u0012\u0002H\u00030\u0004B-\b\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u0012\u001a\u00020\u0013H\u0016J\u0015\u0010\u0014\u001a\u00020\u00132\u0006\u0010\u0015\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0016J\u001b\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00112\u0006\u0010\u0015\u001a\u00028\u0000H\u0003\u00a2\u0006\u0002\u0010\u0018J/\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00192\u0006\u0010\u0015\u001a\u00028\u00002\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00190\fH\u0017\u00a2\u0006\u0002\u0010\u001bJ7\u0010\u0017\u001a\b\u0012\u0004\u0012\u00028\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0015\u001a\u00028\u00002\u0012\u0010\u001a\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00190\fH\u0016\u00a2\u0006\u0002\u0010\u001eR \u0010\u000f\u001a\u0014\u0012\u0004\u0012\u00028\u0000\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00010\u00110\u0010X\u0088\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcom/pyamsoft/pydroid/core/cache/RepositoryMapImpl;", "K", "", "V", "Lcom/pyamsoft/pydroid/core/cache/RepositoryMap;", "initialSize", "", "time", "", "timeUnit", "Ljava/util/concurrent/TimeUnit;", "provideScheduler", "Lkotlin/Function0;", "Lio/reactivex/Scheduler;", "(IJLjava/util/concurrent/TimeUnit;Lkotlin/jvm/functions/Function0;)V", "cache", "Ljava/util/concurrent/ConcurrentHashMap;", "Lcom/pyamsoft/pydroid/core/cache/Repository;", "clearCache", "", "clearKey", "key", "(Ljava/lang/Object;)V", "get", "(Ljava/lang/Object;)Lcom/pyamsoft/pydroid/core/cache/Repository;", "Lio/reactivex/Single;", "fresh", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)Lio/reactivex/Single;", "bypass", "", "(ZLjava/lang/Object;Lkotlin/jvm/functions/Function0;)Lio/reactivex/Single;", "core_release"})
public final class RepositoryMapImpl<K, V>
implements RepositoryMap<K, V> {
    private final ConcurrentHashMap<K, Repository<V>> cache;
    private final long time;
    private final TimeUnit timeUnit;
    private final Function0<Scheduler> provideScheduler;

    @Override
    public void clearCache() {
        this.cache.clear();
    }

    @CheckResult
    private final Repository<V> get(K key) {
        Map map = this.cache;
        Object object = map.get(key);
        if (object == null) {
            object = RepositoryKt.repository(this.time, this.timeUnit, this.provideScheduler);
        }
        return (Repository)object;
    }

    @Override
    @CheckResult
    @NotNull
    public Single<V> get(@NotNull K key, @NotNull Function0<? extends Single<V>> fresh) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull(fresh, (String)"fresh");
        return this.get(key).get(fresh);
    }

    @Override
    @NotNull
    public Single<V> get(boolean bypass, @NotNull K key, @NotNull Function0<? extends Single<V>> fresh) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        Intrinsics.checkParameterIsNotNull(fresh, (String)"fresh");
        return this.get(key).get(bypass, fresh);
    }

    @Override
    public void clearKey(@NotNull K key) {
        Intrinsics.checkParameterIsNotNull(key, (String)"key");
        this.cache.remove(key);
    }

    public RepositoryMapImpl(int initialSize, long time, @NotNull TimeUnit timeUnit, @NotNull Function0<? extends Scheduler> provideScheduler) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)timeUnit), (String)"timeUnit");
        Intrinsics.checkParameterIsNotNull(provideScheduler, (String)"provideScheduler");
        this.time = time;
        this.timeUnit = timeUnit;
        this.provideScheduler = provideScheduler;
        this.cache = new ConcurrentHashMap(initialSize);
    }
}

