/*
 * Decompiled with CFR 0.152.
 */
package com.pyamsoft.pydroid.core.bus;

import androidx.annotation.CheckResult;
import com.pyamsoft.pydroid.core.bus.EventBus;
import io.reactivex.Observable;
import io.reactivex.subjects.PublishSubject;
import io.reactivex.subjects.Subject;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import timber.log.Timber;

@Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\u0018\u0000 \r*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003:\u0001\rB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0007\u001a\b\u0012\u0004\u0012\u00028\u00000\bH\u0016J\u0015\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\fR\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/pyamsoft/pydroid/core/bus/RxBus;", "T", "", "Lcom/pyamsoft/pydroid/core/bus/EventBus;", "()V", "bus", "Lio/reactivex/subjects/Subject;", "listen", "Lio/reactivex/Observable;", "publish", "", "event", "(Ljava/lang/Object;)V", "Companion", "core_release"})
public final class RxBus<T>
implements EventBus<T> {
    private final Subject<T> bus;
    public static final Companion Companion = new Companion(null);

    @Override
    public void publish(@NotNull T event) {
        Intrinsics.checkParameterIsNotNull(event, (String)"event");
        if (this.bus.hasObservers()) {
            this.bus.onNext(event);
        } else {
            Timber.w((String)"No observers on bus, ignore publish event: %s", (Object[])new Object[]{event});
        }
    }

    @Override
    @NotNull
    public Observable<T> listen() {
        return (Observable)this.bus;
    }

    private RxBus() {
        Subject subject = PublishSubject.create().toSerialized();
        Intrinsics.checkExpressionValueIsNotNull((Object)subject, (String)"PublishSubject.create<T>()\n      .toSerialized()");
        this.bus = subject;
    }

    public /* synthetic */ RxBus(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @JvmStatic
    @CheckResult
    @NotNull
    public static final <T> EventBus<T> create() {
        return Companion.create();
    }

    @Metadata(mv={1, 1, 10}, bv={1, 0, 2}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\b\b\u0001\u0010\u0005*\u00020\u0001H\u0007\u00a8\u0006\u0006"}, d2={"Lcom/pyamsoft/pydroid/core/bus/RxBus$Companion;", "", "()V", "create", "Lcom/pyamsoft/pydroid/core/bus/EventBus;", "T", "core_release"})
    public static final class Companion {
        @JvmStatic
        @CheckResult
        @NotNull
        public final <T> EventBus<T> create() {
            return new RxBus(null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

