/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.WarningGroup;
import com.pvsstudio.WarningLanguage;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class WarningCategorizer {
    private WarningCategorizer() {
    }

    public static Pair<WarningGroup, WarningLanguage> byName(String name) {
        if (!name.startsWith("V")) {
            return Pair.of((Object)((Object)WarningGroup.UNKNOWN), (Object)((Object)WarningLanguage.UNKNOWN));
        }
        String code = name.substring(1);
        if (!StringUtils.isNumeric((CharSequence)code)) {
            return Pair.of((Object)((Object)WarningGroup.UNKNOWN), (Object)((Object)WarningLanguage.UNKNOWN));
        }
        return WarningCategorizer.byCode(Integer.parseInt(code));
    }

    public static Pair<WarningGroup, WarningLanguage> byCode(int code) {
        if (code == 4) {
            return Pair.of((Object)((Object)WarningGroup.VIVA64), (Object)((Object)WarningLanguage.C_CPP));
        }
        if (code == 9) {
            return Pair.of((Object)((Object)WarningGroup.FAILS), (Object)((Object)WarningLanguage.UNKNOWN));
        }
        if (code < 14) {
            return Pair.of((Object)((Object)WarningGroup.FAILS), (Object)((Object)WarningLanguage.C_CPP));
        }
        if (code == 51 || code == 52) {
            return Pair.of((Object)((Object)WarningGroup.FAILS), (Object)((Object)WarningLanguage.CS));
        }
        if (code == 61 || code == 62 || code == 63) {
            return Pair.of((Object)((Object)WarningGroup.FAILS), (Object)((Object)WarningLanguage.JAVA));
        }
        if (code < 100) {
            return Pair.of((Object)((Object)WarningGroup.FAILS), (Object)((Object)WarningLanguage.C_CPP));
        }
        if (code > 100 && code < 500) {
            return Pair.of((Object)((Object)WarningGroup.VIVA64), (Object)((Object)WarningLanguage.C_CPP));
        }
        if (code > 500 && code < 800) {
            return Pair.of((Object)((Object)WarningGroup.GA), (Object)((Object)WarningLanguage.C_CPP));
        }
        if (code > 800 && code < 1000) {
            return Pair.of((Object)((Object)WarningGroup.OPTIMIZATION), (Object)((Object)WarningLanguage.C_CPP));
        }
        if (code > 1000 && code < 2000) {
            return Pair.of((Object)((Object)WarningGroup.GA), (Object)((Object)WarningLanguage.C_CPP));
        }
        if (code > 2000 && code < 2500) {
            return Pair.of((Object)((Object)WarningGroup.CUSTOMER_SPECIFIC), (Object)((Object)WarningLanguage.C_CPP));
        }
        if (code > 2500 && code < 3000) {
            return Pair.of((Object)((Object)WarningGroup.MISRA), (Object)((Object)WarningLanguage.C_CPP));
        }
        if (code > 3000 && code < 3500) {
            return Pair.of((Object)((Object)WarningGroup.GA), (Object)((Object)WarningLanguage.CS));
        }
        if (code > 3500 && code < 4000) {
            return Pair.of((Object)((Object)WarningGroup.AUTOSAR), (Object)((Object)WarningLanguage.C_CPP));
        }
        if (code > 4000 && code < 4200) {
            return Pair.of((Object)((Object)WarningGroup.OPTIMIZATION), (Object)((Object)WarningLanguage.CS));
        }
        if (code > 5000 && code < 5300) {
            return Pair.of((Object)((Object)WarningGroup.OWASP), (Object)((Object)WarningLanguage.C_CPP));
        }
        if (code > 5300 && code < 5600) {
            return Pair.of((Object)((Object)WarningGroup.OWASP), (Object)((Object)WarningLanguage.JAVA));
        }
        if (code > 5600 && code < 6000) {
            return Pair.of((Object)((Object)WarningGroup.OWASP), (Object)((Object)WarningLanguage.CS));
        }
        if (code > 6000 && code < 6500) {
            return Pair.of((Object)((Object)WarningGroup.GA), (Object)((Object)WarningLanguage.JAVA));
        }
        return Pair.of((Object)((Object)WarningGroup.UNKNOWN), (Object)((Object)WarningLanguage.UNKNOWN));
    }
}

