/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.PvsStudioDownloader;
import com.pvsstudio.PvsStudioException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class Version {
    public static final String CURRENT_VERSION = "7.31.81895";
    private static String actualVersion = "7.31.81895";
    private static String latestVersion = "";
    private static boolean beta = false;

    private Version() {
    }

    public static String getActualVersion() {
        return actualVersion;
    }

    public static String getLatestVersion() {
        if (latestVersion.isEmpty()) {
            PvsStudioDownloader.tryExecuteAction(Version::initLatestVersion);
        }
        return latestVersion;
    }

    public static boolean isDevelopment() {
        return Objects.equals(CURRENT_VERSION, "0.0.0");
    }

    public static boolean isBeta() {
        return beta;
    }

    public static void setBeta(boolean isBeta) {
        beta = isBeta;
    }

    public static void setActualVersion(String version) {
        actualVersion = version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean initLatestVersion(@NotNull Proxy proxy) {
        try {
            URLConnection connection = new URL(String.format("%s/latest.version", "http://files.pvs-studio.com/java")).openConnection(proxy);
            connection.setReadTimeout(1500);
            connection.setConnectTimeout(1500);
            try (BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
                String firstLine = in.readLine();
                latestVersion = firstLine != null ? firstLine.trim() : "";
                boolean bl = true;
                return bl;
            }
        }
        catch (Exception e) {
            throw new PvsStudioException(e.getMessage());
        }
    }
}

