/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.WarningGroup;
import com.pvsstudio.WarningInfo;
import com.sun.management.OperatingSystemMXBean;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public final class Utils {
    private Utils() {
        throw new IllegalStateException("utility class");
    }

    @NotNull
    public static String absolutePath(@NotNull String path) {
        if (path.equals("~")) {
            path = System.getProperty("user.home");
        } else if (path.startsWith("~\\") || path.startsWith("~/")) {
            path = System.getProperty("user.home") + path.substring(1);
        }
        try {
            path = new File(path).getCanonicalPath();
        }
        catch (IOException ignored) {
            path = new File(path).getAbsolutePath();
        }
        return Utils.normalizePath(path);
    }

    @NotNull
    public static String absolutePath(@NotNull String path, String ... tail) {
        return Utils.absolutePath(Utils.joinPath(path, tail));
    }

    @NotNull
    public static String normalizePath(@NotNull String path) {
        if (path.endsWith("/") || path.endsWith("\\")) {
            path = path.substring(0, path.length() - 1);
        }
        return path.replace("\\", "/");
    }

    public static boolean isAbsolutePath(@NotNull String path) {
        return path.equals("~") || path.startsWith("~/") || path.startsWith("~\\") || new File(path).isAbsolute();
    }

    @NotNull
    public static String joinPath(@NotNull String path, String ... tail) {
        String res = path;
        for (String s : tail) {
            res = res.isEmpty() ? s : (Utils.isAbsolutePath(s) ? Utils.normalizePath(s) : Utils.normalizePath(res) + '/' + s);
        }
        return res;
    }

    @NotNull
    public static String getProjectRelativePath(@NotNull String path, @NotNull String projectPath) {
        projectPath = new File(projectPath).getAbsolutePath();
        File pathFile = new File(path = StringUtils.strip((String)path, (String)" \""));
        if (!pathFile.isAbsolute()) {
            path = new File(projectPath, path).getAbsolutePath();
        }
        return Utils.makeRelativePath(path, projectPath);
    }

    @NotNull
    public static String makeRelativePath(@NotNull String path, @NotNull String root, @NotNull String relativeMark, boolean calcAbsolutePaths) {
        if (root.isEmpty()) {
            return path;
        }
        if (calcAbsolutePaths) {
            path = Utils.absolutePath(path);
            root = Utils.absolutePath(root);
        }
        if (path.equals(root)) {
            return relativeMark;
        }
        if (path.startsWith(root + '/')) {
            return relativeMark + '/' + path.substring(root.length() + 1);
        }
        return path;
    }

    @NotNull
    public static String makeRelativePath(@NotNull String path, @NotNull String root, @NotNull String relativeMark) {
        return Utils.makeRelativePath(path, root, relativeMark, true);
    }

    @NotNull
    public static String makeRelativePath(@NotNull String path, @NotNull String root, boolean calcAbsolutePaths) {
        return Utils.makeRelativePath(path, root, ".", calcAbsolutePaths);
    }

    @NotNull
    public static String makeRelativePath(@NotNull String path, @NotNull String root) {
        return Utils.makeRelativePath(path, root, ".");
    }

    public static boolean isRelative(@NotNull String path, @NotNull String root, boolean calcAbsolutePaths) {
        if (!calcAbsolutePaths) {
            path = path.replace('\\', '/');
            root = root.replace('\\', '/');
        }
        return !Utils.makeRelativePath(path, root, calcAbsolutePaths).equals(path);
    }

    public static boolean isRelative(@NotNull String path, @NotNull String root) {
        return !Utils.makeRelativePath(path, root).equals(path);
    }

    @NotNull
    public static File absolutePath(@NotNull File path) {
        return new File(Utils.absolutePath(path.getAbsolutePath()));
    }

    public static List<String> splitWords(@NotNull String str) {
        String RE_CAMELCASE_OR_SNAKECASE = "(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])|_";
        return Arrays.stream(str.split("(?<!(^|[A-Z]))(?=[A-Z])|(?<!^)(?=[A-Z][a-z])|_")).filter(word -> !word.isEmpty()).collect(Collectors.toList());
    }

    public static boolean isRuleEnabled(AnalyzerConfig config, String rule) {
        if (config.enableAllWarnings.booleanValue() || config.additionalWarnings.contains(rule)) {
            return true;
        }
        if (!config.enabledWarnings.isEmpty() && !config.enabledWarnings.contains(rule) || config.disabledWarnings.contains(rule)) {
            return false;
        }
        if (!config.enabledWarnings.isEmpty()) {
            return true;
        }
        WarningGroup group = WarningGroup.byName(rule);
        if (!config.analysisMode.contains((Object)group)) {
            return false;
        }
        WarningInfo info = WarningInfo.WARNINGS.get(rule);
        return info == null || !info.isDisabledByDefault();
    }

    public static <T> void bubbleSort(List<T> list, Comparator<T> comparator) {
        for (int i = 0; i < list.size() - 1; ++i) {
            T left = list.get(i);
            for (int j = i + 1; j < list.size(); ++j) {
                T right = list.get(j);
                if (comparator.compare(left, right) <= 0) continue;
                list.set(i, right);
                list.set(j, left);
                left = right;
            }
        }
    }

    public static String getLicenseInfoFromSettingsXml(String settingsPath) throws ParserConfigurationException, IOException, SAXException {
        String licenseInfo = "";
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        Document doc = factory.newDocumentBuilder().parse(new File(settingsPath));
        doc.getDocumentElement().normalize();
        String userName = Utils.getNodeValueByTagName(doc, "UserName");
        String serialNumber = Utils.getNodeValueByTagName(doc, "SerialNumber");
        if (userName != null && serialNumber != null) {
            licenseInfo = userName + System.lineSeparator() + serialNumber;
        }
        return licenseInfo;
    }

    public static String getNodeValueByTagName(Document doc, String tagName) {
        Node node;
        String nodeValue = null;
        NodeList nList = doc.getElementsByTagName(tagName);
        if (nList.getLength() > 0 && (node = nList.item(0)).getNodeType() == 1 && node.hasChildNodes()) {
            nodeValue = node.getFirstChild().getNodeValue();
        }
        return nodeValue;
    }

    public static void setNodeValue(Document doc, String tagName, String nodeValue) {
        Node node;
        NodeList nList = doc.getElementsByTagName(tagName);
        if (nList.getLength() > 0 && (node = nList.item(0)).getNodeType() == 1) {
            node.setTextContent(nodeValue);
        }
    }

    public static int getRecommendedThreadsCount() {
        try {
            long memorySize = ((OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean()).getTotalPhysicalMemorySize();
            long logicalCores = Runtime.getRuntime().availableProcessors();
            return (int)Math.max(1L, Math.min(logicalCores, (memorySize /= 0x40000000L) / 2L));
        }
        catch (Exception e) {
            e.printStackTrace();
            return Runtime.getRuntime().availableProcessors();
        }
    }

    public static void createDirectoriesToFile(@NotNull File file) throws PvsStudioException {
        File fileDirectory = file.getParentFile();
        if (fileDirectory != null && !fileDirectory.exists() && !fileDirectory.mkdirs()) {
            throw new PvsStudioException("Directory " + fileDirectory + " does not exist and could not be created");
        }
    }

    public static void createSettingsXmlFileIfNotExists(@NotNull File settingsFile) {
        block14: {
            try {
                if (settingsFile.exists()) break block14;
                Utils.createDirectoriesToFile(settingsFile);
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
                Document doc = docBuilder.newDocument();
                Element rootElement = doc.createElement("ApplicationSettings");
                doc.appendChild(rootElement);
                Element userName = doc.createElement("UserName");
                userName.setTextContent(" ");
                rootElement.appendChild(userName);
                Element serialNumber = doc.createElement("SerialNumber");
                serialNumber.setTextContent(" ");
                rootElement.appendChild(serialNumber);
                try (FileOutputStream output = new FileOutputStream(settingsFile);){
                    TransformerFactory transformerFactory = TransformerFactory.newInstance();
                    Transformer transformer = transformerFactory.newTransformer();
                    transformer.setOutputProperty("indent", "yes");
                    transformer.setOutputProperty("method", "html");
                    transformer.transform(new DOMSource(doc), new StreamResult(output));
                }
            }
            catch (Exception e) {
                throw new PvsStudioException("couldn't create " + settingsFile.getAbsolutePath());
            }
        }
    }

    public static void saveToStandardLicenseFile(@Nullable String userName, @Nullable String licenseKey) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        if (SystemUtils.IS_OS_WINDOWS) {
            Utils.saveToSettingsXml(userName, licenseKey);
        } else {
            Utils.saveToLicFile(userName, licenseKey);
        }
    }

    private static void saveToSettingsXml(@Nullable String userName, @Nullable String serialNumber) throws TransformerException, ParserConfigurationException, IOException, SAXException {
        File settingsFile = new File(AnalyzerConfig.PVS_LICENSE_FILE);
        Utils.createSettingsXmlFileIfNotExists(settingsFile);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setXIncludeAware(false);
        factory.setExpandEntityReferences(false);
        Document doc = factory.newDocumentBuilder().parse(settingsFile);
        doc.getDocumentElement().normalize();
        Utils.setNodeValue(doc, "UserName", userName);
        Utils.setNodeValue(doc, "SerialNumber", serialNumber);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(settingsFile);
        transformer.transform(source, result);
    }

    private static void saveToLicFile(@Nullable String userName, @Nullable String serialNumber) throws IOException {
        File settingsFile = new File(AnalyzerConfig.PVS_LICENSE_FILE);
        Utils.createDirectoriesToFile(settingsFile);
        try (FileWriter writer = new FileWriter(settingsFile);){
            writer.write(String.format("%s%n%s", userName, serialNumber));
        }
    }
}

