/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.TaskParametersProvider;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import picocli.CommandLine;

public abstract class TaskParameterConverter
implements TaskParametersProvider {
    public static final String PREFIX = "pvsstudio.";
    @NotNull
    protected final TaskParametersProvider taskParametersProvider;
    private static final Field[] analyzerConfigNonStaticFields = AnalyzerConfig.getNonStaticFields(AnalyzerConfig.class);
    public static Set<String> analyzerConfigNonStaticFieldsNames = Arrays.stream(analyzerConfigNonStaticFields).map(Field::getName).collect(Collectors.toSet());

    public TaskParameterConverter(@NotNull TaskParametersProvider taskParametersProvider) {
        this.taskParametersProvider = taskParametersProvider;
    }

    @Override
    public boolean hasTaskParameterWithName(@NotNull String parameterName) {
        return this.taskParametersProvider.hasTaskParameterWithName(parameterName);
    }

    @Override
    @Nullable
    public String getTaskParameterValue(@NotNull String parameterName) {
        return this.taskParametersProvider.getTaskParameterValue(parameterName);
    }

    @NotNull
    public static String addPrefix(@NotNull String str) {
        if (!str.startsWith(PREFIX)) {
            return PREFIX + str;
        }
        throw new PvsStudioException("The string " + str + " already starts with the prefix: " + PREFIX);
    }

    @NotNull
    protected abstract Set<String> getTaskParametersNames();

    @NotNull
    protected String mapTaskParameterNameToCommandLineArgumentName(@NotNull String taskParameterName) {
        return this.getAnalyzerConfigFieldWithOptionAnnotation(taskParameterName).getAnnotation(CommandLine.Option.class).names()[0];
    }

    @NotNull
    protected abstract Class<?> getParameterValueType(@NotNull String var1);

    protected final Set<String> addPrefixToTaskParametersNames(@NotNull Stream<String> taskParametersNames) {
        return taskParametersNames.map(TaskParameterConverter::addPrefix).collect(Collectors.toSet());
    }

    protected final Stream<Field> getAnalyzerConfigFieldsWithOptionAnnotation() {
        return Arrays.stream(analyzerConfigNonStaticFields).filter(f -> f.isAnnotationPresent(CommandLine.Option.class));
    }

    @NotNull
    protected final Field getAnalyzerConfigFieldWithOptionAnnotation(@NotNull String taskParameterName) {
        Optional<Field> analyzerConfigFieldForTaskParameter = this.getAnalyzerConfigFieldsWithOptionAnnotation().filter(f -> TaskParameterConverter.addPrefix(f.getName()).equals(taskParameterName)).findFirst();
        if (analyzerConfigFieldForTaskParameter.isPresent()) {
            return analyzerConfigFieldForTaskParameter.get();
        }
        throw new PvsStudioException("No mapping found for plugin parameter named: " + taskParameterName);
    }

    @NotNull
    private Stream<String> mapTaskParameterNameToCommandLineArguments(@NotNull String taskParameterName) {
        String commandLineArgumentName = this.mapTaskParameterNameToCommandLineArgumentName(taskParameterName);
        String commandLineArgumentValue = this.getTaskParameterValue(taskParameterName);
        if (commandLineArgumentValue == null || commandLineArgumentValue.isEmpty()) {
            throw new PvsStudioException("There is no value specified for the plugin parameter named:" + taskParameterName);
        }
        Class<?> parameterValueType = this.getParameterValueType(taskParameterName);
        if (Collection.class.isAssignableFrom(parameterValueType)) {
            return Stream.of(commandLineArgumentValue.split(";")).flatMap(it -> Stream.of(commandLineArgumentName, it));
        }
        if (Objects.equals(Boolean.class, parameterValueType)) {
            return Stream.of(commandLineArgumentName);
        }
        return Stream.of(commandLineArgumentName, commandLineArgumentValue);
    }

    @NotNull
    public final AnalyzerConfig convert() {
        String[] args = (String[])this.getTaskParametersNames().stream().filter(this::hasTaskParameterWithName).flatMap(this::mapTaskParameterNameToCommandLineArguments).toArray(String[]::new);
        return (AnalyzerConfig)CommandLine.populateCommand((Object)AnalyzerConfig.blankConfig(), (String[])args);
    }
}

