/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.AnalyzeTask;
import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.CredentialsTask;
import com.pvsstudio.PvsGradleTask;
import com.pvsstudio.SuppressTask;
import com.pvsstudio.TaskParameterConverter;
import java.util.HashMap;
import java.util.Map;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

public class PvsStudioGradlePlugin
implements Plugin<Project> {
    private static final String PLUGIN_CONFIG_CLOSURE_NAME = "pvsstudio";

    public Map<String, Class<? extends PvsGradleTask>> getTaskNameToClass() {
        HashMap<String, Class<? extends PvsGradleTask>> result = new HashMap<String, Class<? extends PvsGradleTask>>();
        result.put("pvsAnalyze", AnalyzeTask.class);
        result.put("pvsCredentials", CredentialsTask.class);
        result.put("pvsSuppress", SuppressTask.class);
        return result;
    }

    public void apply(@NotNull Project project) {
        project.getExtensions().create(PLUGIN_CONFIG_CLOSURE_NAME, AnalyzerConfig.class, new Object[0]);
        project.getProperties().put(TaskParameterConverter.addPrefix("licensePath"), null);
        for (Map.Entry<String, Class<? extends PvsGradleTask>> taskNameToClass : this.getTaskNameToClass().entrySet()) {
            String taskName = taskNameToClass.getKey();
            Class<? extends PvsGradleTask> taskClass = taskNameToClass.getValue();
            if (taskClass.isInstance(AnalyzeTask.class)) {
                project.afterEvaluate(proj -> {
                    PvsGradleTask cfr_ignored_0 = (PvsGradleTask)project.getTasks().create(taskName, taskClass, task -> project.evaluationDependsOnChildren());
                });
                continue;
            }
            project.getTasks().create(taskName, taskClass);
        }
    }
}

