/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.JsonProject;
import com.pvsstudio.PvsJavaPluginConfig;
import com.pvsstudio.PvsStudioDownloader;
import com.pvsstudio.PvsStudioException;
import com.pvsstudio.TaskParameterConverter;
import com.pvsstudio.Utils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface MavenGradlePluginTask {
    @NotNull
    default public String taskFailedMessage() {
        return "PVS-Studio " + this.taskName() + " task failed";
    }

    @NotNull
    default public String pluginTaskParameterStartFlag() {
        String character;
        PvsJavaPluginConfig.Plugin pluginType = this.pluginType();
        switch (pluginType) {
            case MAVEN: {
                character = "D";
                break;
            }
            case GRADLE: {
                character = "P";
                break;
            }
            default: {
                throw new PvsStudioException("Incorrect plugin type: " + (Object)((Object)pluginType));
            }
        }
        String hyphen = "-";
        return "-" + character;
    }

    @NotNull
    default public String commandExampleMessage() {
        return "";
    }

    default public void printExampleMessage() {
        String exampleMessage = this.commandExampleMessage();
        if (!exampleMessage.isEmpty()) {
            String newLine = System.lineSeparator();
            System.out.println(newLine + exampleMessage + newLine);
        }
    }

    @NotNull
    public String taskName();

    @NotNull
    public String projectRootFolder();

    @NotNull
    public PvsJavaPluginConfig.Plugin pluginType();

    @Nullable
    public Exception executeTaskAndGetException(@NotNull PvsJavaPluginConfig var1, @NotNull JsonProject var2);

    default public void initJavaAnalyzerCore() {
        PvsStudioDownloader.initCore();
    }

    @NotNull
    default public String projectFolderAbsolutePath() {
        return Utils.absolutePath(this.projectRootFolder());
    }

    @NotNull
    default public JsonProject jsonProject() {
        return JsonProject.EMPTY;
    }

    @NotNull
    public TaskParameterConverter taskParameterConverter();

    @NotNull
    default public AnalyzerConfig configFromBuildSystemScript() {
        return AnalyzerConfig.blankConfig();
    }

    @NotNull
    default public AnalyzerConfig globalConfig() {
        return AnalyzerConfig.getGlobalConfig();
    }

    @Nullable
    public Exception taskException(@Nullable PvsStudioException var1);

    @NotNull
    default public AnalyzerConfig configFromProperties() {
        return this.taskParameterConverter().convert();
    }

    default public PvsJavaPluginConfig pvsJavaPluginConfig(@NotNull String projectPath, @NotNull PvsJavaPluginConfig.Plugin plugin, @NotNull AnalyzerConfig configFromPluginProperties, @NotNull AnalyzerConfig configFromBuildGradleOrPomFile, @NotNull AnalyzerConfig globalConfig) throws PvsStudioException {
        if (plugin == PvsJavaPluginConfig.Plugin.IDEA) {
            throw new PvsStudioException("Invalid value specified for plugin: " + (Object)((Object)plugin));
        }
        AnalyzerConfig mergedAndNormalizedConfig = AnalyzerConfig.mergeAndNormalizeAfterMerge(configFromPluginProperties, configFromBuildGradleOrPomFile, globalConfig);
        return new PvsJavaPluginConfig(mergedAndNormalizedConfig, plugin, projectPath);
    }

    @NotNull
    default public PvsStudioException pvsStudioExceptionForRunAnalyzerProcessFromMavenOrGradlePlugins(int javaCoreReturnCode, @NotNull PvsJavaPluginConfig config) {
        return new PvsStudioException("Running the Java analyzer failed." + System.lineSeparator() + "Command line: " + String.join((CharSequence)" ", config.getCommandLineForRunJavaCoreWithTempCfgFileCreation()) + System.lineSeparator() + "Java analyzer return code: " + javaCoreReturnCode);
    }
}

