/*
 * Decompiled with CFR 0.152.
 */
package com.pvsstudio;

import com.pvsstudio.AnalyzerConfig;
import com.pvsstudio.License;
import com.pvsstudio.Utils;
import com.pvsstudio.Version;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.jetbrains.annotations.NotNull;

public final class LicenseRegistration {
    private LicenseRegistration() {
    }

    private static Optional<String> getMacOsName() {
        String[] ver;
        String osVersion = System.getProperty("os.version");
        if (osVersion != null && (ver = osVersion.split("\\.")).length == 3 && Arrays.stream(ver).allMatch(StringUtils::isNumeric)) {
            String[] names = new String[]{"Cheetah", "Puma", "Jaguar", "Panther", "Tiger", "Leopard", "Snow Leopard", "Lion", "Mountain Lion", "Mavericks", "Yosemite", "El Capitan", "Sierra", "High Sierra", "Mojave"};
            if (Integer.parseInt(ver[0]) != 10 || Integer.parseInt(ver[1]) >= names.length) {
                return Optional.of(osVersion);
            }
            return Optional.of(names[Integer.parseInt(ver[1])]);
        }
        return Optional.empty();
    }

    private static Optional<String> getLinuxDistributionName(String s) {
        List<String> knownDistributions = Arrays.asList("Debian", "Ubuntu", "Mint", "openSUSE", "Fedora", "CentOS", "Red Hat", "Gentoo", "Arch Linux", "Mandriva", "SteamOS", "Manjaro", "Elementary", "FreeBSD", "OpenBSD", "Slackware");
        return knownDistributions.stream().filter(s::contains).findFirst();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Optional<String> getLinuxDistributionName(String fileName, String pattern) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(new FileInputStream(fileName)));){
            String line;
            do {
                if ((line = reader.readLine()) == null) return Optional.empty();
            } while (!line.startsWith(pattern + '='));
            Optional<String> res = LicenseRegistration.getLinuxDistributionName(line.substring(pattern.length() + 1));
            if (!res.isPresent()) return Optional.empty();
            Optional<String> optional = res;
            return optional;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Optional.empty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Optional<String> getLinuxDistributionName(List<String> cmd) {
        Process process = null;
        try {
            process = new ProcessBuilder(cmd).start();
            try (BufferedReader br = new BufferedReader(new InputStreamReader(process.getInputStream()));){
                Optional<String> res;
                String firstLine = br.readLine();
                if (firstLine != null && (res = LicenseRegistration.getLinuxDistributionName(firstLine)).isPresent()) {
                    Optional<String> optional = res;
                    return optional;
                }
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (process != null) {
                try {
                    process.destroy();
                    process.waitFor();
                }
                catch (Exception exception) {}
            }
        }
        return Optional.empty();
    }

    private static Optional<String> getLinuxDistributionName() {
        Optional<String> res = LicenseRegistration.getLinuxDistributionName("/etc/os-release", "NAME");
        if (res.isPresent()) {
            return res;
        }
        res = LicenseRegistration.getLinuxDistributionName(Arrays.asList("lsb_release", "-ds"));
        if (res.isPresent()) {
            return res;
        }
        return Optional.empty();
    }

    private static long GetHashCodePVS(String input) {
        long sum = 0L;
        for (char ch : input.toCharArray()) {
            if (ch == ' ' || ch == '\t') continue;
            boolean hiBit = (sum & Integer.toUnsignedLong(Integer.MIN_VALUE)) != 0L;
            sum <<= 1;
            sum ^= (long)ch;
            if (!hiBit) continue;
            sum ^= Integer.toUnsignedLong(1);
        }
        return sum;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void sendLicenseRegistration(@NotNull String name, @NotNull String key, @NotNull License license) {
        block41: {
            try {
                Optional<String> line;
                if (!license.valid || license.isFreeLicense(name, key)) {
                    return;
                }
                if (!new File(AnalyzerConfig.PVS_JAVA_STANDARD_DIRECTORY).exists() && !new File(AnalyzerConfig.PVS_JAVA_STANDARD_DIRECTORY).mkdirs()) {
                    return;
                }
                String hashFileName = Utils.absolutePath(AnalyzerConfig.PVS_JAVA_STANDARD_DIRECTORY, "30d59484437b42b");
                long newHash = 0x100000000L + LicenseRegistration.GetHashCodePVS(key);
                if (new File(hashFileName).exists() && (line = Files.lines(Paths.get(hashFileName, new String[0])).findFirst()).isPresent()) {
                    long oldHash;
                    long l = oldHash = line.get().matches("-?\\d+") ? Long.parseLong(line.get()) : 0L;
                    if (oldHash != 0L && newHash == oldHash) {
                        return;
                    }
                }
                HttpURLConnection connection = null;
                try {
                    String osVersion;
                    String osName;
                    if (SystemUtils.IS_OS_WINDOWS) {
                        osName = "Windows";
                        osVersion = System.getProperty("os.name");
                    } else if (SystemUtils.IS_OS_MAC) {
                        osName = "macOS";
                        osVersion = LicenseRegistration.getMacOsName().orElse("Other");
                    } else if (SystemUtils.IS_OS_LINUX) {
                        osName = "Linux";
                        osVersion = LicenseRegistration.getLinuxDistributionName().orElse("Other");
                    } else {
                        osName = System.getProperty("os.name");
                        osVersion = System.getProperty("os.version");
                    }
                    String pcName = InetAddress.getLocalHost().getHostName();
                    String pvsVersion = Version.getActualVersion().replaceAll("\\.\\d+$", "");
                    String data = String.format("key=%1$s&type=%2$s&os=%3$s&version=%4$s&language=Java&pvsversion=%5$s&pcname=%6$s", key, license.type, osName, osVersion, pvsVersion, pcName).replace(" ", "%20");
                    connection = (HttpURLConnection)new URL("https://wlm.viva64.com/").openConnection();
                    connection.setRequestMethod("POST");
                    connection.setDoOutput(true);
                    connection.setRequestProperty("charset", "UTF-8");
                    connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
                    connection.setConnectTimeout(10000);
                    try (OutputStreamWriter outputStreamWriter = new OutputStreamWriter(connection.getOutputStream());){
                        outputStreamWriter.write(data);
                    }
                    if (connection.getResponseCode() != 200) break block41;
                    var13_14 = null;
                    try (BufferedWriter writer = new BufferedWriter(new FileWriter(hashFileName));){
                        writer.write(String.valueOf(newHash));
                    }
                    catch (Throwable throwable) {
                        var13_14 = throwable;
                        throw throwable;
                    }
                }
                finally {
                    if (connection != null) {
                        connection.disconnect();
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

